/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk.model.internalpstate.regionOfInterest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DoubleStats {
    private String unit = "";
    private double sum = 0.0;
    private List<Double> numbers = new ArrayList<Double>();
    private boolean sorted = false;

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public void add(double d) {
        this.numbers.add(d);
        this.sorted = false;
        this.sum += d;
    }

    public boolean hasSamples() {
        return !this.numbers.isEmpty();
    }

    public int getNumberOfSamples() {
        return this.numbers.size();
    }

    public int getNumberOfPairs() {
        return this.getNumberOfSamples() * (this.getNumberOfSamples() - 1) / 2;
    }

    public double getMin() {
        return this.hasSamples() ? this.getSorted(0) : Double.POSITIVE_INFINITY;
    }

    public double getMax() {
        return this.hasSamples() ? this.getSorted(this.getNumberOfSamples() - 1) : Double.NEGATIVE_INFINITY;
    }

    public double getMedian() {
        if (this.hasSamples()) {
            int n = (this.getNumberOfSamples() - 1) / 2;
            if (this.getNumberOfSamples() % 2 == 0) {
                return (this.getSorted(n) + this.getSorted(n + 1)) / 2.0;
            }
            return this.getSorted(n);
        }
        return 0.0;
    }

    public double getQuantile(double d) {
        int n = Math.max(0, Math.min(this.getNumberOfSamples() - 1, (int)(d * (double)(this.getNumberOfSamples() - 1))));
        return this.hasSamples() ? this.getSorted(n) : 0.0;
    }

    public double getSorted(int n) {
        this.sort();
        return this.numbers.get(n);
    }

    public double getSum() {
        return this.sum;
    }

    public double getAverage() {
        return this.hasSamples() ? this.sum / (double)this.getNumberOfSamples() : 0.0;
    }

    public double getGeometricAverage() {
        double d = 0.0;
        for (double d2 : this.numbers) {
            d += Math.log(d2);
        }
        return this.hasSamples() ? Math.exp(d / (double)this.getNumberOfSamples()) : 0.0;
    }

    public double getStandardDeviation() {
        if (this.getNumberOfSamples() > 1) {
            double d = 0.0;
            double d2 = this.getAverage();
            for (double d3 : this.numbers) {
                double d4 = d3 - d2;
                d += d4 * d4;
            }
            double d5 = Math.max(0.0, d / (double)(this.getNumberOfSamples() - 1));
            return Math.sqrt(d5);
        }
        return 0.0;
    }

    public double getMeanDifference() {
        this.sort();
        double d = 0.0;
        for (int i = 0; i < this.getNumberOfSamples(); ++i) {
            int n = i;
            int n2 = this.getNumberOfSamples() - i - 1;
            int n3 = n - n2;
            d += (double)n3 * this.numbers.get(i);
        }
        return this.getNumberOfSamples() > 1 ? d / (double)this.getNumberOfPairs() : 0.0;
    }

    public double getSimilarityMeanQuotient() {
        this.sort();
        double d = 0.0;
        for (int i = 0; i < this.getNumberOfSamples(); ++i) {
            int n = i;
            int n2 = this.getNumberOfSamples() - i - 1;
            int n3 = n2 - n;
            d += (double)n3 * Math.log(this.numbers.get(i));
        }
        return this.getNumberOfSamples() > 1 ? Math.exp(d / (double)this.getNumberOfPairs()) : 1.0;
    }

    private void sort() {
        if (!this.sorted) {
            Collections.sort(this.numbers);
            this.sorted = true;
        }
    }

    public String toString() {
        if (this.hasSamples()) {
            return "N=" + this.getNumberOfSamples() + ",\nMin=" + this.getMin() + this.unit + ", Q1/4=" + this.getQuantile(0.25) + this.unit + ", Median=" + this.getMedian() + this.unit + ", Q3/4=" + this.getQuantile(0.75) + this.unit + ", Max=" + this.getMax() + this.unit + "\nAvg=" + this.getAverage() + this.unit + ", GeomAvg=" + this.getGeometricAverage() + this.unit + ",\nMeanDiff=" + this.getMeanDifference() + this.unit + ", StdDev=" + this.getStandardDeviation() + this.unit;
        }
        return "N=0";
    }
}

