/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk.imageplane;

import com.visustt.dicomTk.imageplane.ae;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.vecmath.Matrix3d;

public class ImagePlane {
    private static final int MAX_DISTANCE_POINT_TO_IMAGE_PLANE = 3;
    private double width;
    private double height;
    private double[] anchor;
    private double[] normedRowOrient;
    private double[] normedColOrient;
    private double[] _normalVector;
    private double pixelSpacingX;
    private double pixelSpacingY;
    private String frameOfReferenceUID;
    private boolean flipped = false;

    public ImagePlane(double d, double d2, double[] dArray, double[] dArray2, double[] dArray3, double d3, double d4) {
        this(d, d2, dArray, dArray2, dArray3, d3, d4, "");
    }

    public ImagePlane(double d, double d2, double[] dArray, double[] dArray2, double[] dArray3, double d3, double d4, String string) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("invalid value for width: " + d + ". Value must be > 0");
        }
        try {
            if (d2 <= 0.0) {
                throw new IllegalArgumentException("invalid value for height: " + d2 + ". Value must be > 0");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ImagePlane.a(illegalArgumentException);
        }
        this.width = d;
        this.height = d2;
        this.anchor = dArray;
        this.pixelSpacingX = d3;
        this.pixelSpacingY = d4;
        this.frameOfReferenceUID = string;
        this.setImageOrientation(ae.ab(dArray2), ae.ab(dArray3));
    }

    public ImagePlane(ImagePlane imagePlane) {
        this.width = imagePlane.width;
        this.height = imagePlane.height;
        this.anchor = imagePlane.anchor;
        this.pixelSpacingX = imagePlane.pixelSpacingX;
        this.pixelSpacingY = imagePlane.pixelSpacingY;
        this.setImageOrientation(ae.ab(imagePlane.normedRowOrient), ae.ab(imagePlane.normedColOrient));
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public double[] getAnchor() {
        return this.anchor;
    }

    public double[] getCorrectedAnchor() {
        block2: {
            try {
                if (!(this.pixelSpacingX > 0.0) || !(this.pixelSpacingY > 0.0)) break block2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ImagePlane.a(illegalArgumentException);
            }
            double[] dArray = ae.aa(this.normedRowOrient, -0.5 * this.pixelSpacingX);
            double[] dArray2 = ae.aa(this.normedColOrient, -0.5 * this.pixelSpacingY);
            return ae.aa(this.anchor, ae.aa(dArray, dArray2));
        }
        return this.anchor;
    }

    public final double[] getCenter() {
        block2: {
            try {
                if (!(this.pixelSpacingX > 0.0) || !(this.pixelSpacingY > 0.0)) break block2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ImagePlane.a(illegalArgumentException);
            }
            double[] dArray = ae.aa(this.normedRowOrient, -0.5 * this.pixelSpacingX + 0.5 * this.width);
            double[] dArray2 = ae.aa(this.normedColOrient, -0.5 * this.pixelSpacingY + 0.5 * this.height);
            return ae.aa(this.anchor, ae.aa(dArray, dArray2));
        }
        return this.anchor;
    }

    public void setCorrectedAnchor(double[] dArray) {
        block3: {
            block2: {
                try {
                    if (!(this.pixelSpacingX > 0.0) || !(this.pixelSpacingY > 0.0)) break block2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ImagePlane.a(illegalArgumentException);
                }
                double[] dArray2 = ae.aa(this.normedRowOrient, 0.5 * this.pixelSpacingX);
                double[] dArray3 = ae.aa(this.normedColOrient, 0.5 * this.pixelSpacingY);
                this.anchor = ae.aa(dArray, ae.aa(dArray2, dArray3));
                break block3;
            }
            this.anchor = dArray;
        }
    }

    public double[] getRowOrient() {
        return this.normedRowOrient;
    }

    public double[] getColOrient() {
        return this.normedColOrient;
    }

    public double getPixelSpacingX() {
        return this.pixelSpacingX;
    }

    public void setPixelSpacingX(double d) {
        this.pixelSpacingX = d;
    }

    public double getPixelSpacingY() {
        return this.pixelSpacingY;
    }

    public void setPixelSpacingY(double d) {
        this.pixelSpacingY = d;
    }

    public void setImageWidth(double d) {
        this.width = d;
    }

    public void setImageHeight(double d) {
        this.height = d;
    }

    public void setImagePosition(double[] dArray) {
        this.anchor = dArray;
    }

    private void setRowOrient(double[] dArray) {
        this.normedRowOrient = ae.ab(dArray);
    }

    private void setColOrient(double[] dArray) {
        this.normedColOrient = ae.ab(dArray);
    }

    public void setImageOrientation(double[] dArray) {
        this.setImageOrientation(new double[]{dArray[0], dArray[1], dArray[2]}, new double[]{dArray[3], dArray[4], dArray[5]});
    }

    public void setImageOrientation(double[] dArray, double[] dArray2) {
        this.setRowOrient(dArray);
        this.setColOrient(dArray2);
        this._normalVector = ae.ab(ae.ae(this.normedRowOrient, this.normedColOrient));
    }

    public double[] getNormalVector() {
        return this._normalVector;
    }

    public String toString() {
        return "anchor: (x,y,z) = (" + this.anchor[0] + "," + this.anchor[1] + ", " + this.anchor[2] + ")\norientation row: (x,y,z) =(" + this.normedRowOrient[0] + ", " + this.normedRowOrient[1] + ", " + this.normedRowOrient[2] + ")\norientation cols: (x,y,z) =(" + this.normedColOrient[0] + ", " + this.normedColOrient[1] + ", " + this.normedColOrient[2] + ")\nsize (widht/height) = " + this.width + ", " + this.height + ")\nnormal vector: (x,y,z) =(" + this._normalVector[0] + ", " + this._normalVector[1] + ", " + this._normalVector[2] + ")";
    }

    public double getDistance(ImagePlane imagePlane) {
        try {
            if (imagePlane == null) {
                return Double.NaN;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ImagePlane.a(illegalArgumentException);
        }
        return this.getDistance(imagePlane.getCorrectedAnchor());
    }

    public double getDistanceOfCenter(ImagePlane imagePlane) {
        try {
            if (imagePlane == null) {
                return Double.NaN;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ImagePlane.a(illegalArgumentException);
        }
        return this.getDistance(imagePlane.getCenter());
    }

    public double getDistance(double[] dArray) {
        double[] dArray2 = ae.ab(this.getCorrectedAnchor(), dArray);
        return ae.ac(dArray2, this.getNormalVector());
    }

    public double[] getProjectionInWorldCoordinates(double[] dArray) {
        double[] dArray2 = this.getCorrectedAnchor();
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = this._normalVector[0];
        double d5 = this._normalVector[1];
        double d6 = this._normalVector[2];
        double d7 = -d4 * dArray2[0] - d5 * dArray2[1] - d6 * dArray2[2];
        double d8 = d4 * d + d5 * d2 + d6 * d3 + d7;
        double d9 = d4 * d4 + d5 * d5 + d6 * d6;
        double d10 = d8 / d9;
        double[] dArray3 = new double[]{d - d4 * d10, d2 - d5 * d10, d3 - d6 * d10};
        return dArray3;
    }

    public Point2D.Double getProjection(double[] dArray) {
        double[] dArray2 = this.getProjectionInWorldCoordinates(dArray);
        double[] dArray3 = this.getCorrectedAnchor();
        dArray2[0] = dArray2[0] - dArray3[0];
        dArray2[1] = dArray2[1] - dArray3[1];
        dArray2[2] = dArray2[2] - dArray3[2];
        double d = (this.normedRowOrient[0] * dArray2[0] + this.normedRowOrient[1] * dArray2[1] + this.normedRowOrient[2] * dArray2[2]) / this.pixelSpacingX;
        double d2 = (this.normedColOrient[0] * dArray2[0] + this.normedColOrient[1] * dArray2[1] + this.normedColOrient[2] * dArray2[2]) / this.pixelSpacingY;
        return new Point2D.Double(d, d2);
    }

    public Point2D.Double getProjectionWithDistanceCheck(double[] dArray) {
        return this.getProjectionWithDistanceCheck(dArray, 3.0);
    }

    public Point2D.Double getProjectionWithDistanceCheck(double[] dArray, double d) {
        double[] dArray2 = this.getCorrectedAnchor();
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = this._normalVector[0];
        double d6 = this._normalVector[1];
        double d7 = this._normalVector[2];
        double d8 = -d5 * dArray2[0] - d6 * dArray2[1] - d7 * dArray2[2];
        double d9 = d5 * d2 + d6 * d3 + d7 * d4 + d8;
        double d10 = d5 * d5 + d6 * d6 + d7 * d7;
        double d11 = d9 / d10;
        double d12 = d2 - d5 * d11;
        double d13 = d3 - d6 * d11;
        double d14 = d4 - d7 * d11;
        double d15 = Math.abs(d9) / Math.sqrt(d10);
        try {
            if (d15 > d) {
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ImagePlane.a(illegalArgumentException);
        }
        double d16 = (this.normedRowOrient[0] * (d12 -= dArray2[0]) + this.normedRowOrient[1] * (d13 -= dArray2[1]) + this.normedRowOrient[2] * (d14 -= dArray2[2])) / this.pixelSpacingX;
        double d17 = (this.normedColOrient[0] * d12 + this.normedColOrient[1] * d13 + this.normedColOrient[2] * d14) / this.pixelSpacingY;
        return new Point2D.Double(d16, d17);
    }

    public Matrix3d getOrientationMatrix() {
        return new Matrix3d(this.normedRowOrient[0], this.normedColOrient[0], this._normalVector[0], this.normedRowOrient[1], this.normedColOrient[1], this._normalVector[1], this.normedRowOrient[2], this.normedColOrient[2], this._normalVector[2]);
    }

    public double[] getOrientationMatrixAsDouble() {
        return new double[]{this.normedRowOrient[0], this.normedColOrient[0], this._normalVector[0], this.normedRowOrient[1], this.normedColOrient[1], this._normalVector[1], this.normedRowOrient[2], this.normedColOrient[2], this._normalVector[2]};
    }

    public double getNormalVectorAngle(ImagePlane imagePlane) {
        try {
            if (imagePlane == null) {
                return 1.0;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ImagePlane.a(illegalArgumentException);
        }
        double d = Math.abs(ae.ad(this._normalVector, imagePlane.getNormalVector()));
        return Math.acos(d) * 180.0 / Math.PI;
    }

    public Line2D.Double getCutline(ImagePlane imagePlane, boolean bl) {
        Line2D.Double double_;
        block3: {
            double_ = this.getUnflippedCutline(imagePlane);
            if (bl) {
                double d = double_.x1;
                double d2 = double_.y1;
                double d3 = double_.x2;
                double d4 = double_.y2;
                double d5 = (d4 - d2) / (d3 - d);
                try {
                    if (!(Math.abs(d5) < 1.0) || !(d > d3)) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ImagePlane.a(illegalArgumentException);
                }
                double_ = new Line2D.Double(d3, d4, d, d2);
            }
        }
        return double_;
    }

    public Line2D.Double getCutline(ImagePlane imagePlane) {
        return this.getCutline(imagePlane, true);
    }

    private Line2D.Double getUnflippedCutline(ImagePlane imagePlane) {
        Line2D.Double double_;
        double d = ae.ac(this.getNormalVector(), imagePlane.getRowOrient());
        double d2 = ae.ac(this.getNormalVector(), imagePlane.getColOrient());
        try {
            double_ = Math.abs(d) > Math.abs(d2) ? this.calcCuttingRows(imagePlane, d, d2) : this.calcCuttingCols(imagePlane, d, d2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ImagePlane.a(illegalArgumentException);
        }
        Line2D.Double double_2 = double_;
        return double_2;
    }

    private Line2D.Double calcCuttingRows(ImagePlane imagePlane, double d, double d2) {
        double[] dArray = ae.ab(imagePlane.getCorrectedAnchor(), this.getCorrectedAnchor());
        double d3 = ae.ac(this.getNormalVector(), dArray) / d;
        double d4 = d2 / d;
        double d5 = ae.ac(this.getRowOrient(), imagePlane.getRowOrient());
        double d6 = ae.ac(this.getColOrient(), imagePlane.getRowOrient());
        double d7 = ae.ac(this.getRowOrient(), dArray) - d3 * d5;
        double d8 = ae.ac(this.getColOrient(), dArray) - d3 * d6;
        double d9 = d7 + imagePlane.getHeight() * (ae.ac(this.getRowOrient(), imagePlane.getColOrient()) - d4 * d5);
        double d10 = d8 + imagePlane.getHeight() * (ae.ac(this.getColOrient(), imagePlane.getColOrient()) - d4 * d6);
        return new Line2D.Double(d7, d8, d9, d10);
    }

    private Line2D.Double calcCuttingCols(ImagePlane imagePlane, double d, double d2) {
        double[] dArray = ae.ab(imagePlane.getCorrectedAnchor(), this.getCorrectedAnchor());
        double d3 = ae.ac(this.getNormalVector(), dArray) / d2;
        double d4 = d / d2;
        double d5 = ae.ac(this.getRowOrient(), imagePlane.getColOrient());
        double d6 = ae.ac(this.getColOrient(), imagePlane.getColOrient());
        double d7 = ae.ac(this.getRowOrient(), dArray) - d3 * d5;
        double d8 = ae.ac(this.getColOrient(), dArray) - d3 * d6;
        double d9 = d7 + imagePlane.getWidth() * (ae.ac(this.getRowOrient(), imagePlane.getRowOrient()) - d4 * d5);
        double d10 = d8 + imagePlane.getWidth() * (ae.ac(this.getColOrient(), imagePlane.getRowOrient()) - d4 * d6);
        return new Line2D.Double(d7, d8, d9, d10);
    }

    public double[] getImageCenterPoint() {
        double d = this.width;
        double d2 = this.height;
        double d3 = this.anchor[0] + (d * this.normedRowOrient[0] + d2 * this.normedColOrient[0]) / 2.0;
        double d4 = this.anchor[1] + (d * this.normedRowOrient[1] + d2 * this.normedColOrient[1]) / 2.0;
        double d5 = this.anchor[2] + (d * this.normedRowOrient[2] + d2 * this.normedColOrient[2]) / 2.0;
        double[] dArray = new double[]{d3, d4, d5};
        return dArray;
    }

    public double[] getWorldCoordinatesFromSubpixel(Point2D.Double double_) {
        return this.getWorldCoordinatesFromSubpixel(double_.x, double_.y);
    }

    public double[] getWorldCoordinatesFromSubpixel(double d, double d2) {
        double[] dArray = this.getCorrectedAnchor();
        double d3 = d * this.pixelSpacingX;
        double d4 = d2 * this.pixelSpacingY;
        return new double[]{dArray[0] + d3 * this.normedRowOrient[0] + d4 * this.normedColOrient[0], dArray[1] + d3 * this.normedRowOrient[1] + d4 * this.normedColOrient[1], dArray[2] + d3 * this.normedRowOrient[2] + d4 * this.normedColOrient[2]};
    }

    public double[] getWorldCoordinatesFromPixel(int n, int n2) {
        double[] dArray = this.getAnchor();
        double d = (double)n * this.pixelSpacingX;
        double d2 = (double)n2 * this.pixelSpacingY;
        return new double[]{dArray[0] + d * this.normedRowOrient[0] + d2 * this.normedColOrient[0], dArray[1] + d * this.normedRowOrient[1] + d2 * this.normedColOrient[1], dArray[2] + d * this.normedRowOrient[2] + d2 * this.normedColOrient[2]};
    }

    public String getFrameOfReferenceUID() {
        return this.frameOfReferenceUID;
    }

    public void setFrameOfReferenceUID(String string) {
        this.frameOfReferenceUID = string;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean bl) {
        this.flipped = bl;
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

