/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk;

import com.visustt.dicomTk.BaseDicomTagNames;
import com.visustt.dicomTk.CommonDicomException;
import com.visustt.dicomTk.DicomElementList;
import com.visustt.dicomTk.DicomModule;
import com.visustt.dicomTk.DicomTag;
import com.visustt.dicomTk.DicomTagNames;
import com.visustt.dicomTk.InvalidDataException;
import com.visustt.dicomTk.PersonName;
import com.visustt.dicomTk.data.DicomElement;
import com.visustt.dicomTk.data.aaa;
import com.visustt.dicomTk.data.aac;
import com.visustt.dicomTk.data.aae;
import com.visustt.dicomTk.data.aam;
import com.visustt.dicomTk.data.aap;
import com.visustt.dicomTk.data.av;
import com.visustt.dicomTk.data.az;
import com.visustt.dicomTk.util.aaf;
import java.util.Date;
import java.util.Vector;

public class StudyModule
extends DicomModule {
    private String cachedAccessionNumber = null;
    private String cachedStudyInstanceUID = null;
    private String cachedStudyDate = null;
    private Date cachedStudyDateDate = null;
    private static final Vector<DicomTag> tagList = new Vector();

    public StudyModule(DicomElementList dicomElementList) {
        super(dicomElementList);
    }

    public StudyModule(DicomModule dicomModule) {
        super(dicomModule);
    }

    public String getStudyID() {
        return this.getString(BaseDicomTagNames.TAG_studyID);
    }

    public void setStudyID(String string) throws InvalidDataException {
        this.insertDicomElement(new com.visustt.dicomTk.data.aaf(BaseDicomTagNames.TAG_studyID, string));
    }

    public String getStudyDate() {
        if (this.cachedStudyDate == null) {
            this.cachedStudyDate = this.getString(BaseDicomTagNames.TAG_studyDate);
        }
        return this.cachedStudyDate;
    }

    public Date getStudyDateAsDate() {
        if (this.cachedStudyDateDate == null) {
            this.cachedStudyDateDate = this.getDate(BaseDicomTagNames.TAG_studyDate);
        }
        return this.cachedStudyDateDate;
    }

    public void setStudyDate(Date date) {
        this.cachedStudyDate = null;
        this.cachedStudyDateDate = null;
        this.insertDicomElement(new az(BaseDicomTagNames.TAG_studyDate, date));
    }

    public void setStudyDate(String string) throws InvalidDataException {
        this.cachedStudyDate = null;
        this.cachedStudyDateDate = null;
        this.insertDicomElement(new az(BaseDicomTagNames.TAG_studyDate, string));
    }

    public String getStudyTime() {
        return this.getString(BaseDicomTagNames.TAG_studyTime);
    }

    public Date getStudyTimeAsDate() {
        return this.getDate(BaseDicomTagNames.TAG_studyTime);
    }

    public void setStudyTime(Date date) {
        this.insertDicomElement(new aaa(BaseDicomTagNames.TAG_studyTime, date));
    }

    public void setStudyTime(String string) throws InvalidDataException {
        this.insertDicomElement(new aaa(BaseDicomTagNames.TAG_studyTime, string));
    }

    public String getStudyInstanceUID() {
        if (this.cachedStudyInstanceUID == null) {
            this.cachedStudyInstanceUID = this.getString(BaseDicomTagNames.TAG_studyInstanceUID);
        }
        return this.cachedStudyInstanceUID;
    }

    public void setStudyInstanceUID(String string) throws InvalidDataException {
        this.cachedStudyInstanceUID = null;
        this.insertDicomElement(new aap(BaseDicomTagNames.TAG_studyInstanceUID, string));
    }

    public String getStudyDescription() {
        return this.getString(BaseDicomTagNames.TAG_studyDescription);
    }

    public void setStudyDescription(String string) throws InvalidDataException {
        this.insertDicomElement(new aac(BaseDicomTagNames.TAG_studyDescription, string));
    }

    public String getAccessionNumber() {
        if (this.cachedAccessionNumber == null) {
            this.cachedAccessionNumber = this.getString(BaseDicomTagNames.TAG_accessionNumber);
        }
        return this.cachedAccessionNumber;
    }

    public void setAccessionNumber(String string) throws InvalidDataException {
        this.cachedAccessionNumber = null;
        this.insertDicomElement(new com.visustt.dicomTk.data.aaf(BaseDicomTagNames.TAG_accessionNumber, string));
    }

    public String getAdmissionID() {
        return this.getString(BaseDicomTagNames.TAG_admissionID);
    }

    public void setAdmissionID(String string) throws InvalidDataException {
        this.insertDicomElement(new aac(BaseDicomTagNames.TAG_admissionID, string));
    }

    public PersonName getReferringPhysiciansName() {
        return this.getPersonName(BaseDicomTagNames.TAG_referringPhysicianName);
    }

    public void setReferringPhysiciansName(PersonName personName) throws InvalidDataException {
        String string = null;
        if (personName != null) {
            string = personName.getDICOMString();
        }
        this.insertDicomElement(new aae(BaseDicomTagNames.TAG_referringPhysicianName, string));
    }

    public void setReferringPhysiciansName(String string) throws InvalidDataException {
        this.insertDicomElement(new aae(BaseDicomTagNames.TAG_referringPhysicianName, string));
    }

    public void setModalitiesInStudy(String string) throws InvalidDataException {
        this.insertDicomElement(new aam(DicomTagNames.TAG_modalitiesInStudy, string));
    }

    public void createDefaultModule(String string) throws InvalidDataException {
        this.setStudyID("");
        this.setStudyInstanceUID(string);
        this.setStudyDate(new Date());
        this.setStudyTime(new Date());
        this.setAccessionNumber("");
        this.setReferringPhysiciansName("");
        this.setSequence(BaseDicomTagNames.TAG_referencedStudySequence);
    }

    public void setReferencedStudySequence(DicomElementList dicomElementList) {
        av av2 = new av(BaseDicomTagNames.TAG_referencedStudySequence);
        av2.aa(dicomElementList);
        this.insertDicomElement(av2);
    }

    public DicomElement getReferencedStudySequence() {
        if (this.getDicomElement(BaseDicomTagNames.TAG_referencedStudySequence) != null) {
            return this.getDicomElement(BaseDicomTagNames.TAG_referencedStudySequence);
        }
        return null;
    }

    public void setVisusFreeStudy(int n, String string) throws InvalidDataException {
        DicomTag dicomTag = null;
        switch (n) {
            case 1: {
                dicomTag = DicomTagNames.TAG_visusFreeStudy1;
                break;
            }
            case 2: {
                dicomTag = DicomTagNames.TAG_visusFreeStudy2;
                break;
            }
            case 3: {
                dicomTag = DicomTagNames.TAG_visusFreeStudy3;
                break;
            }
            case 4: {
                dicomTag = DicomTagNames.TAG_visusFreeStudy4;
                break;
            }
            case 5: {
                dicomTag = DicomTagNames.TAG_visusFreeStudy5;
                break;
            }
            case 6: {
                dicomTag = DicomTagNames.TAG_visusFreeStudy6;
                break;
            }
            case 7: {
                dicomTag = DicomTagNames.TAG_visusFreeStudy7;
                break;
            }
            case 8: {
                dicomTag = DicomTagNames.TAG_visusFreeStudy8;
                break;
            }
            case 9: {
                dicomTag = DicomTagNames.TAG_visusFreeStudy9;
                break;
            }
            default: {
                throw new InvalidDataException("Field free" + n + " currently not supported.");
            }
        }
        this.insertDicomElement(new aac(dicomTag, string));
    }

    public void complementMendatoryFields() throws CommonDicomException {
        try {
            if (this.getStudyInstanceUID() == null) {
                this.setStudyInstanceUID(aaf.aa());
            }
        }
        catch (CommonDicomException commonDicomException) {
            throw StudyModule.a(commonDicomException);
        }
        try {
            if (this.getStudyID() == null) {
                this.addAttribute(DicomTagNames.TAG_studyID);
            }
        }
        catch (CommonDicomException commonDicomException) {
            throw StudyModule.a(commonDicomException);
        }
        try {
            if (this.getAccessionNumber() == null) {
                this.addAttribute(DicomTagNames.TAG_accessionNumber);
            }
        }
        catch (CommonDicomException commonDicomException) {
            throw StudyModule.a(commonDicomException);
        }
        try {
            if (this.getReferringPhysiciansName() == null) {
                this.addAttribute(DicomTagNames.TAG_referringPhysicianName);
            }
        }
        catch (CommonDicomException commonDicomException) {
            throw StudyModule.a(commonDicomException);
        }
        try {
            if (this.getStudyDate() == null) {
                this.addAttribute(DicomTagNames.TAG_studyDate);
            }
        }
        catch (CommonDicomException commonDicomException) {
            throw StudyModule.a(commonDicomException);
        }
        try {
            if (this.getStudyTime() == null) {
                this.addAttribute(DicomTagNames.TAG_studyTime);
            }
        }
        catch (CommonDicomException commonDicomException) {
            throw StudyModule.a(commonDicomException);
        }
    }

    public boolean isValid() {
        return this.contents.hasDicomElement(BaseDicomTagNames.TAG_studyInstanceUID) && !"".equals(this.getStudyInstanceUID()) && this.contents.hasDicomElement(BaseDicomTagNames.TAG_studyID) && this.contents.hasDicomElement(BaseDicomTagNames.TAG_studyDate) && this.contents.hasDicomElement(BaseDicomTagNames.TAG_studyTime) && this.contents.hasDicomElement(BaseDicomTagNames.TAG_referringPhysicianName) && this.contents.hasDicomElement(BaseDicomTagNames.TAG_accessionNumber);
    }

    public StudyModule getCopy() {
        return new StudyModule(DicomElementList.getCopy(this.getDicomElementList(), tagList));
    }

    static {
        tagList.add(BaseDicomTagNames.TAG_studyInstanceUID);
        tagList.add(BaseDicomTagNames.TAG_studyDate);
        tagList.add(BaseDicomTagNames.TAG_studyTime);
        tagList.add(BaseDicomTagNames.TAG_referringPhysicianName);
        tagList.add(BaseDicomTagNames.TAG_studyID);
        tagList.add(BaseDicomTagNames.TAG_accessionNumber);
        tagList.add(BaseDicomTagNames.TAG_studyDescription);
        tagList.add(BaseDicomTagNames.TAG_referencedStudySequence);
        tagList.add(BaseDicomTagNames.TAG_procedureCodeSequence);
        tagList.add(BaseDicomTagNames.TAG_reasonForRequestedProcedureCodeSequence);
    }

    private static CommonDicomException a(CommonDicomException commonDicomException) {
        return commonDicomException;
    }
}

