/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk;

import com.visustt.dicomTk.BaseDicomTagNames;
import com.visustt.dicomTk.DicomElementList;
import com.visustt.dicomTk.DicomModule;
import com.visustt.dicomTk.DicomTag;
import com.visustt.dicomTk.DicomTagNames;
import com.visustt.dicomTk.InvalidDataException;
import com.visustt.dicomTk.PersonName;
import com.visustt.dicomTk.data.aaa;
import com.visustt.dicomTk.data.aac;
import com.visustt.dicomTk.data.aae;
import com.visustt.dicomTk.data.aam;
import com.visustt.dicomTk.data.av;
import com.visustt.dicomTk.data.az;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class PatientModule
extends DicomModule {
    private String cachedPatientBirthdate = null;
    private Date cachedPatientBirthdateDate = null;
    private String cachedPatientName = null;
    private PersonName cachedPatientNamePN = null;
    private static final List<DicomTag> tagList = new ArrayList<DicomTag>();

    public PatientModule(DicomElementList dicomElementList) {
        super(dicomElementList);
    }

    public PatientModule(DicomModule dicomModule) {
        super(dicomModule);
    }

    public PatientModule() {
    }

    public PersonName getPatientName() {
        if (this.cachedPatientNamePN == null) {
            this.cachedPatientNamePN = this.getPersonName(BaseDicomTagNames.TAG_patientsName);
        }
        return this.cachedPatientNamePN;
    }

    public String getPatientNameAsString() {
        if (this.cachedPatientName == null) {
            this.cachedPatientName = this.getPersonNameAsString(BaseDicomTagNames.TAG_patientsName);
        }
        return this.cachedPatientName;
    }

    public void setPatientName(PersonName personName) throws InvalidDataException {
        try {
            this.cachedPatientName = null;
            this.cachedPatientNamePN = null;
            if (personName != null) {
                this.insertDicomElement(new aae(BaseDicomTagNames.TAG_patientsName, personName.getDICOMString()));
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw PatientModule.a(invalidDataException);
        }
    }

    public void setPatientName(String string) throws InvalidDataException {
        try {
            this.cachedPatientName = null;
            this.cachedPatientNamePN = null;
            if (string != null) {
                this.insertDicomElement(new aae(BaseDicomTagNames.TAG_patientsName, string));
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw PatientModule.a(invalidDataException);
        }
    }

    public String getPatientID() {
        return this.getString(BaseDicomTagNames.TAG_patientsID);
    }

    public void setPatientID(String string) throws InvalidDataException {
        this.insertDicomElement(new aac(BaseDicomTagNames.TAG_patientsID, string));
    }

    public String getPatientBirthDate() {
        if (this.cachedPatientBirthdate == null) {
            this.cachedPatientBirthdate = this.getString(BaseDicomTagNames.TAG_patientsBirthDate);
        }
        return this.cachedPatientBirthdate;
    }

    public Date getPatientBirthDateAsDate() {
        if (this.cachedPatientBirthdateDate == null) {
            this.cachedPatientBirthdateDate = this.getDate(BaseDicomTagNames.TAG_patientsBirthDate);
        }
        return this.cachedPatientBirthdateDate;
    }

    public void setPatientBirthDate(Date date) {
        this.cachedPatientBirthdate = null;
        this.cachedPatientBirthdateDate = null;
        this.insertDicomElement(new az(BaseDicomTagNames.TAG_patientsBirthDate, date));
    }

    public void setPatientBirthDate(String string) throws InvalidDataException {
        this.cachedPatientBirthdate = null;
        this.cachedPatientBirthdateDate = null;
        this.insertDicomElement(new az(BaseDicomTagNames.TAG_patientsBirthDate, string));
    }

    public String getPatientBirthTime() {
        return this.getString(BaseDicomTagNames.TAG_patientsBirthTime);
    }

    public Date getPatientBirthTimeAsDate() {
        return this.getDate(BaseDicomTagNames.TAG_patientsBirthTime);
    }

    public void setPatientBirthTime(Date date) {
        this.insertDicomElement(new aaa(BaseDicomTagNames.TAG_patientsBirthTime, date));
    }

    public void setPatientBirthTime(String string) throws InvalidDataException {
        this.insertDicomElement(new aaa(DicomTagNames.TAG_patientsBirthTime, string));
    }

    public String getPatientSex() {
        return this.getString(BaseDicomTagNames.TAG_patientsSex);
    }

    public void setPatientSex(String string) throws InvalidDataException {
        this.insertDicomElement(new aam(BaseDicomTagNames.TAG_patientsSex, string));
    }

    public String getOtherPatientIDs() {
        return this.getValueAsString(BaseDicomTagNames.TAG_otherPatientIDs);
    }

    public void setOtherPatientIDs(String string) throws InvalidDataException {
        this.insertDicomElement(new aac(BaseDicomTagNames.TAG_otherPatientIDs, string));
    }

    public av getOtherPatientIDsSequence() {
        return this.getSequence(BaseDicomTagNames.TAG_otherPatientIDsSequence);
    }

    public void setOtherPatientIDsSequence(av av2) {
        this.insertDicomElement(av2);
    }

    public String getOtherPatientNames() {
        return this.getValueAsString(BaseDicomTagNames.TAG_otherPatientNames);
    }

    public void setOtherPatientNames(String string) throws InvalidDataException {
        this.insertDicomElement(new aac(BaseDicomTagNames.TAG_otherPatientNames, string));
    }

    public String getIssuerOfPatientID() {
        return this.getValueAsString(BaseDicomTagNames.TAG_issuerOfPatientID);
    }

    public void setIssuerOfPatientID(String string) throws InvalidDataException {
        this.insertDicomElement(new aac(BaseDicomTagNames.TAG_issuerOfPatientID, string));
    }

    public void createDefaultModule() throws InvalidDataException {
        this.setPatientName("");
        this.setPatientID("");
        this.setPatientBirthDate("");
        this.setPatientSex("O");
    }

    public void complementMendatoryFields() throws InvalidDataException {
        try {
            if (!this.contents.hasDicomElement(BaseDicomTagNames.TAG_patientsName)) {
                this.contents.addAttribute(BaseDicomTagNames.TAG_patientsName);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw PatientModule.a(invalidDataException);
        }
        try {
            if (!this.contents.hasDicomElement(BaseDicomTagNames.TAG_patientsID)) {
                this.contents.addAttribute(BaseDicomTagNames.TAG_patientsID);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw PatientModule.a(invalidDataException);
        }
        try {
            if (this.getPatientBirthDate() == null) {
                this.setPatientBirthDate("19000101");
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw PatientModule.a(invalidDataException);
        }
        try {
            if (!this.contents.hasDicomElement(BaseDicomTagNames.TAG_patientsSex)) {
                this.contents.addAttribute(BaseDicomTagNames.TAG_patientsSex);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw PatientModule.a(invalidDataException);
        }
    }

    public boolean isValid() {
        return this.contents.hasDicomElement(BaseDicomTagNames.TAG_patientsName) && this.contents.hasDicomElement(BaseDicomTagNames.TAG_patientsID) && this.contents.hasDicomElement(BaseDicomTagNames.TAG_patientsBirthDate) && this.contents.hasDicomElement(BaseDicomTagNames.TAG_patientsSex);
    }

    public PatientModule getCopy() {
        return new PatientModule(DicomElementList.getCopy(this.getDicomElementList(), new Vector<DicomTag>(tagList)));
    }

    public void replace(PatientModule patientModule) throws InvalidDataException {
        block27: {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            block18: {
                                                block17: {
                                                    block16: {
                                                        block15: {
                                                            block14: {
                                                                String string = patientModule.getPatientNameAsString();
                                                                try {
                                                                    if (string == null) break block14;
                                                                    this.setPatientName(string);
                                                                    break block15;
                                                                }
                                                                catch (InvalidDataException invalidDataException) {
                                                                    throw PatientModule.a(invalidDataException);
                                                                }
                                                            }
                                                            this.removeDicomElement(DicomTagNames.TAG_patientsName);
                                                        }
                                                        String string = patientModule.getPatientID();
                                                        try {
                                                            if (string == null) break block16;
                                                            this.setPatientID(string);
                                                            break block17;
                                                        }
                                                        catch (InvalidDataException invalidDataException) {
                                                            throw PatientModule.a(invalidDataException);
                                                        }
                                                    }
                                                    this.removeDicomElement(DicomTagNames.TAG_patientsID);
                                                }
                                                String string = patientModule.getPatientBirthDate();
                                                try {
                                                    if (string == null) break block18;
                                                    this.setPatientBirthDate(string);
                                                    break block19;
                                                }
                                                catch (InvalidDataException invalidDataException) {
                                                    throw PatientModule.a(invalidDataException);
                                                }
                                            }
                                            this.removeDicomElement(DicomTagNames.TAG_patientsBirthDate);
                                        }
                                        String string = patientModule.getPatientBirthTime();
                                        try {
                                            if (string == null) break block20;
                                            this.setPatientBirthTime(string);
                                            break block21;
                                        }
                                        catch (InvalidDataException invalidDataException) {
                                            throw PatientModule.a(invalidDataException);
                                        }
                                    }
                                    this.removeDicomElement(DicomTagNames.TAG_patientsBirthTime);
                                }
                                String string = patientModule.getPatientSex();
                                try {
                                    if (string == null) break block22;
                                    this.setPatientSex(string);
                                    break block23;
                                }
                                catch (InvalidDataException invalidDataException) {
                                    throw PatientModule.a(invalidDataException);
                                }
                            }
                            this.removeDicomElement(DicomTagNames.TAG_patientsSex);
                        }
                        String string = patientModule.getOtherPatientIDs();
                        try {
                            if (string == null) break block24;
                            this.setOtherPatientIDs(string);
                            break block25;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw PatientModule.a(invalidDataException);
                        }
                    }
                    this.removeDicomElement(DicomTagNames.TAG_otherPatientIDs);
                }
                String string = patientModule.getOtherPatientNames();
                try {
                    if (string == null) break block26;
                    this.setOtherPatientNames(string);
                    break block27;
                }
                catch (InvalidDataException invalidDataException) {
                    throw PatientModule.a(invalidDataException);
                }
            }
            this.removeDicomElement(DicomTagNames.TAG_otherPatientNames);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof PatientModule)) {
            return false;
        }
        PatientModule patientModule = (PatientModule)object;
        if (!PatientModule.equals(this.getPatientNameAsString(), patientModule.getPatientNameAsString())) {
            return false;
        }
        if (!PatientModule.equals(this.getPatientID(), patientModule.getPatientID())) {
            return false;
        }
        if (!PatientModule.equals(this.getPatientBirthDate(), patientModule.getPatientBirthDate())) {
            return false;
        }
        if (!PatientModule.equals(this.getPatientBirthTime(), patientModule.getPatientBirthTime())) {
            return false;
        }
        if (!PatientModule.equals(this.getPatientSex(), patientModule.getPatientSex())) {
            return false;
        }
        if (!PatientModule.equals(this.getOtherPatientIDs(), patientModule.getOtherPatientIDs())) {
            return false;
        }
        return PatientModule.equals(this.getOtherPatientNames(), patientModule.getOtherPatientNames());
    }

    private static final boolean equals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string2 != null && string.equals(string2);
    }

    static {
        tagList.add(BaseDicomTagNames.TAG_patientsName);
        tagList.add(BaseDicomTagNames.TAG_patientsID);
        tagList.add(BaseDicomTagNames.TAG_patientsBirthDate);
        tagList.add(BaseDicomTagNames.TAG_patientsSex);
        tagList.add(BaseDicomTagNames.TAG_referencedPatientSequence);
        tagList.add(BaseDicomTagNames.TAG_patientsBirthTime);
        tagList.add(BaseDicomTagNames.TAG_otherPatientIDs);
        tagList.add(BaseDicomTagNames.TAG_otherPatientNames);
        tagList.add(BaseDicomTagNames.TAG_ethnicGroup);
        tagList.add(BaseDicomTagNames.TAG_patientComments);
        tagList.add(BaseDicomTagNames.TAG_issuerOfPatientID);
    }

    private static InvalidDataException a(InvalidDataException invalidDataException) {
        return invalidDataException;
    }
}

