/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk;

import com.visustt.dicomTk.BaseDicomTagNames;
import com.visustt.dicomTk.DicomElementList;
import com.visustt.dicomTk.DicomModule;
import com.visustt.dicomTk.DicomTag;
import com.visustt.dicomTk.DicomTagNames;
import com.visustt.dicomTk.InvalidDataException;
import com.visustt.dicomTk.UnavailableException;
import com.visustt.dicomTk.data.DicomElement;
import com.visustt.dicomTk.data.aam;
import com.visustt.dicomTk.data.aap;
import com.visustt.dicomTk.data.al;
import com.visustt.dicomTk.data.ar;
import com.visustt.dicomTk.data.au;
import com.visustt.dicomTk.data.av;
import com.visustt.dicomTk.util.aaa;
import com.visustt.dicomTk.util.aq;

public class ImagePixelModuleBasic
extends DicomModule {
    private Boolean cachedPixelRepresentationSigned = null;
    private Boolean cachedVisusNoPixelData = null;
    private Boolean cachedVisusDICOMHeader = null;
    private String cachedPhotometricInterpretation = null;
    private Integer cachedPixelRepresentationAsInt = null;

    public ImagePixelModuleBasic(DicomElementList dicomElementList) {
        super(dicomElementList);
    }

    public ImagePixelModuleBasic() {
    }

    public ImagePixelModuleBasic(DicomModule dicomModule) {
        super(dicomModule);
    }

    public Integer getSamplesPerPixel() {
        return this.getInteger(BaseDicomTagNames.TAG_samplesPerPixel);
    }

    public int getSamplesPerPixelAsInt() throws InvalidDataException {
        return this.getInt(BaseDicomTagNames.TAG_samplesPerPixel);
    }

    public void setSamplesPerPixel(int n) throws InvalidDataException {
        this.insertDicomElement(new al(BaseDicomTagNames.TAG_samplesPerPixel, n));
    }

    public String getPhotometricInterpretation() {
        if (this.cachedPhotometricInterpretation == null) {
            this.cachedPhotometricInterpretation = this.getString(BaseDicomTagNames.TAG_photometricInterpretation);
        }
        return this.cachedPhotometricInterpretation;
    }

    public void setPhotometricInterpretation(String string) throws InvalidDataException {
        this.cachedPhotometricInterpretation = null;
        this.insertDicomElement(new aam(BaseDicomTagNames.TAG_photometricInterpretation, string));
    }

    public Integer getRows() {
        return this.getInteger(BaseDicomTagNames.TAG_rows);
    }

    public int getRowsAsInt() throws InvalidDataException {
        return this.getInt(BaseDicomTagNames.TAG_rows);
    }

    public void setRows(int n) throws InvalidDataException {
        this.insertDicomElement(new al(BaseDicomTagNames.TAG_rows, n));
    }

    public Integer getColumns() {
        return this.getInteger(BaseDicomTagNames.TAG_columns);
    }

    public int getColumnsAsInt() throws InvalidDataException {
        return this.getInt(BaseDicomTagNames.TAG_columns);
    }

    public void setColumns(int n) throws InvalidDataException {
        this.insertDicomElement(new al(BaseDicomTagNames.TAG_columns, n));
    }

    public String getPixelAspectRatio() {
        return this.getString(BaseDicomTagNames.TAG_pixelAspectRatio);
    }

    public Integer getBitsAllocated() {
        return this.getInteger(BaseDicomTagNames.TAG_bitsAllocated);
    }

    public int getBitsAllocatedAsInt() throws InvalidDataException {
        return this.getInt(BaseDicomTagNames.TAG_bitsAllocated);
    }

    public int getBitsAllocatedAsInt(int n) {
        try {
            return this.getInt(BaseDicomTagNames.TAG_bitsAllocated);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public void setBitsAllocated(int n) throws InvalidDataException {
        this.insertDicomElement(new al(BaseDicomTagNames.TAG_bitsAllocated, n));
    }

    public Integer getBitsStored() {
        return this.getInteger(BaseDicomTagNames.TAG_bitsStored);
    }

    public int getBitsStoredAsInt() throws InvalidDataException {
        return this.getInt(BaseDicomTagNames.TAG_bitsStored);
    }

    public int getBitsStoredAsInt(int n) {
        try {
            return this.getInt(BaseDicomTagNames.TAG_bitsStored);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public void setBitsStored(int n) throws InvalidDataException {
        this.insertDicomElement(new al(BaseDicomTagNames.TAG_bitsStored, n));
    }

    public Integer getHighBit() {
        return this.getInteger(BaseDicomTagNames.TAG_highBit);
    }

    public int getHighBitAsInt() throws InvalidDataException {
        return this.getInt(BaseDicomTagNames.TAG_highBit);
    }

    public int getHighBitAsInt(int n) {
        try {
            return this.getInt(BaseDicomTagNames.TAG_highBit);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public void setHighBit(int n) throws InvalidDataException {
        this.insertDicomElement(new al(BaseDicomTagNames.TAG_highBit, n));
    }

    public Integer getPixelRepresentation() {
        if (this.cachedPixelRepresentationAsInt == null) {
            this.cachedPixelRepresentationAsInt = this.getInteger(BaseDicomTagNames.TAG_pixelRepresentation);
        }
        return this.cachedPixelRepresentationAsInt;
    }

    public void setPixelRepresentation(int n) throws InvalidDataException {
        this.cachedPixelRepresentationSigned = null;
        this.cachedPixelRepresentationAsInt = null;
        this.insertDicomElement(new al(BaseDicomTagNames.TAG_pixelRepresentation, n));
    }

    public void setPixelRepresentationCorrect(int n) {
        this.cachedPixelRepresentationSigned = null;
        this.cachedPixelRepresentationAsInt = null;
        try {
            this.insertDicomElement(new al(BaseDicomTagNames.TAG_pixelRepresentation, n));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getPixelRepresentationAsInt(int n) {
        try {
            return this.getPixelRepresentationAsInt();
        }
        catch (Exception exception) {
            return n;
        }
    }

    public int getPixelRepresentationAsInt() throws InvalidDataException {
        try {
            if (this.cachedPixelRepresentationAsInt == null) {
                this.cachedPixelRepresentationAsInt = this.getInteger(BaseDicomTagNames.TAG_pixelRepresentation);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ImagePixelModuleBasic.a(invalidDataException);
        }
        return this.cachedPixelRepresentationAsInt;
    }

    public boolean isPixelRepresentationSigned() {
        if (this.cachedPixelRepresentationSigned == null) {
            boolean bl = this.getPixelRepresentationAsInt(0) != 0;
            this.cachedPixelRepresentationSigned = bl;
        }
        return this.cachedPixelRepresentationSigned;
    }

    public void setPixelRepresentation(boolean bl) throws InvalidDataException {
        int n;
        DicomTag dicomTag;
        al al2;
        al al3;
        ImagePixelModuleBasic imagePixelModuleBasic;
        try {
            al al4;
            this.cachedPixelRepresentationSigned = null;
            this.cachedPixelRepresentationAsInt = null;
            imagePixelModuleBasic = this;
            al3 = al4;
            al2 = al4;
            dicomTag = BaseDicomTagNames.TAG_pixelRepresentation;
            n = bl ? 1 : 0;
        }
        catch (InvalidDataException invalidDataException) {
            throw ImagePixelModuleBasic.a(invalidDataException);
        }
        al3(dicomTag, n);
        imagePixelModuleBasic.insertDicomElement(al2);
        this.cachedPixelRepresentationSigned = bl;
    }

    public byte[] getPixelDataBytes() throws InvalidDataException {
        return ((ar)this.getDicomElement(BaseDicomTagNames.TAG_pixelData)).getValueAsByteArray();
    }

    public short[] getPixelDataShort() throws InvalidDataException {
        return ((au)this.getDicomElement(BaseDicomTagNames.TAG_pixelData)).getValueAsShortArray();
    }

    public void convertPixelDataBytesToWords() throws UnavailableException, InvalidDataException {
        if (this.arePixelDataBytes()) {
            au au2 = new au(BaseDicomTagNames.TAG_pixelData);
            byte[] byArray = this.getPixelDataBytes();
            if (byArray != null) {
                short[] sArray = new short[byArray.length];
                if (this.isPixelRepresentationSigned()) {
                    try {
                        for (int i = 0; i < sArray.length; ++i) {
                            sArray[i] = byArray[i];
                        }
                    }
                    catch (UnavailableException unavailableException) {
                        throw ImagePixelModuleBasic.a(unavailableException);
                    }
                }
                try {
                    for (int i = 0; i < sArray.length; ++i) {
                        sArray[i] = (short)(byArray[i] & 0xFF);
                    }
                }
                catch (UnavailableException unavailableException) {
                    throw ImagePixelModuleBasic.a(unavailableException);
                }
                au2.aa(sArray);
                this.insertDicomElement(au2);
            }
        }
    }

    public boolean isEmbeddedPixelData() {
        DicomElement dicomElement = this.contents.getDicomElement(BaseDicomTagNames.TAG_pixelData);
        return dicomElement instanceof av;
    }

    public boolean hasDicomUndecodedTag() {
        DicomElement dicomElement = this.contents.getDicomElement(DicomTagNames.TAG_visusUndecodedPixelData);
        return dicomElement != null;
    }

    public Object getPixelData() throws InvalidDataException {
        block4: {
            DicomElement dicomElement;
            block5: {
                dicomElement = this.contents.getDicomElement(BaseDicomTagNames.TAG_pixelData);
                try {
                    try {
                        if (dicomElement == null) break block4;
                        if (!(dicomElement instanceof au)) break block5;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw ImagePixelModuleBasic.a(invalidDataException);
                    }
                    return ((au)dicomElement).getValueAsShortArray();
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImagePixelModuleBasic.a(invalidDataException);
                }
            }
            return ((ar)dicomElement).getValueAsByteArray();
        }
        return null;
    }

    public boolean arePixelDataBytes() throws InvalidDataException {
        return this.getDicomElement(BaseDicomTagNames.TAG_pixelData) instanceof ar;
    }

    public boolean arePixelDataShorts() {
        return this.getDicomElement(BaseDicomTagNames.TAG_pixelData) instanceof au;
    }

    public void setPixelDataBytes(byte[] byArray) {
        this.insertDicomElement(new ar(BaseDicomTagNames.TAG_pixelData, byArray));
    }

    public void setPixelDataWords(short[] sArray) {
        this.insertDicomElement(new au(BaseDicomTagNames.TAG_pixelData, sArray));
    }

    public void setPixelDataInts(int[] nArray) {
        this.insertDicomElement(new ar(BaseDicomTagNames.TAG_pixelData, aq.aa(nArray)));
    }

    public void setPixelDataIntMultiframe(int[][] nArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        int[] nArray2 = new int[n * n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray2[i * n2 + j] = nArray[i][j];
            }
        }
        this.setPixelDataInts(nArray2);
    }

    public void setPixelDataShortMultiframe(short[][] sArray) {
        int n = sArray.length;
        int n2 = sArray[0].length;
        short[] sArray2 = new short[n * n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                sArray2[i * n2 + j] = sArray[i][j];
            }
        }
        this.setPixelDataWords(sArray2);
    }

    public void setPixelDataByteMultiframe(byte[][] byArray) {
        int n = byArray.length;
        int n2 = byArray[0].length;
        byte[] byArray2 = new byte[n * n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                byArray2[i * n2 + j] = byArray[i][j];
            }
        }
        this.setPixelDataBytes(byArray2);
    }

    public void setPixelData(Object object) throws InvalidDataException {
        block16: {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block15: {
                                    try {
                                        if (object == null) {
                                            return;
                                        }
                                    }
                                    catch (InvalidDataException invalidDataException) {
                                        throw ImagePixelModuleBasic.a(invalidDataException);
                                    }
                                    try {
                                        if (!(object instanceof byte[])) break block15;
                                        this.setPixelDataBytes((byte[])object);
                                        break block16;
                                    }
                                    catch (InvalidDataException invalidDataException) {
                                        throw ImagePixelModuleBasic.a(invalidDataException);
                                    }
                                }
                                try {
                                    if (!(object instanceof short[])) break block17;
                                    this.setPixelDataWords((short[])object);
                                    break block16;
                                }
                                catch (InvalidDataException invalidDataException) {
                                    throw ImagePixelModuleBasic.a(invalidDataException);
                                }
                            }
                            try {
                                if (!(object instanceof int[])) break block18;
                                this.setPixelDataInts((int[])object);
                                break block16;
                            }
                            catch (InvalidDataException invalidDataException) {
                                throw ImagePixelModuleBasic.a(invalidDataException);
                            }
                        }
                        try {
                            if (!(object instanceof byte[][])) break block19;
                            this.setPixelDataByteMultiframe((byte[][])object);
                            break block16;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw ImagePixelModuleBasic.a(invalidDataException);
                        }
                    }
                    try {
                        if (!(object instanceof short[][])) break block20;
                        this.setPixelDataShortMultiframe((short[][])object);
                        break block16;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw ImagePixelModuleBasic.a(invalidDataException);
                    }
                }
                try {
                    if (!(object instanceof int[][])) break block21;
                    this.setPixelDataIntMultiframe((int[][])object);
                    break block16;
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImagePixelModuleBasic.a(invalidDataException);
                }
            }
            throw new InvalidDataException("Pixel Data must be byte[], short[] or int[] - but is " + object.getClass().getName());
        }
    }

    public Integer getPlanarConfiguration() {
        return this.getInteger(BaseDicomTagNames.TAG_planarConfiguration);
    }

    public void setPlanarConfiguration(int n) throws InvalidDataException {
        this.insertDicomElement(new al(BaseDicomTagNames.TAG_planarConfiguration, n));
    }

    public boolean isPlanarConfiguration() throws InvalidDataException {
        boolean bl;
        Integer n = this.getInteger(BaseDicomTagNames.TAG_planarConfiguration);
        try {
            if (n == null) {
                return false;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ImagePixelModuleBasic.a(invalidDataException);
        }
        try {
            bl = n != 0;
        }
        catch (InvalidDataException invalidDataException) {
            throw ImagePixelModuleBasic.a(invalidDataException);
        }
        return bl;
    }

    public void setPlanarConfiguration(boolean bl) throws InvalidDataException {
        int n;
        DicomTag dicomTag;
        al al2;
        al al3;
        ImagePixelModuleBasic imagePixelModuleBasic;
        try {
            al al4;
            imagePixelModuleBasic = this;
            al3 = al4;
            al2 = al4;
            dicomTag = BaseDicomTagNames.TAG_planarConfiguration;
            n = bl ? 1 : 0;
        }
        catch (InvalidDataException invalidDataException) {
            throw ImagePixelModuleBasic.a(invalidDataException);
        }
        al3(dicomTag, n);
        imagePixelModuleBasic.insertDicomElement(al2);
    }

    public aaa getMaxPixelRange() {
        int n = this.getBitsStoredAsInt(8);
        if (n == 0) {
            return new aaa(0, 0);
        }
        if (!this.isPixelRepresentationSigned()) {
            return new aaa(0, aq.aa[n]);
        }
        return new aaa(-aq.aa[n - 1], aq.aa[n - 1] - 1);
    }

    public boolean hasPixelPaddingValue() {
        return this.existsDicomElement(BaseDicomTagNames.TAG_pixelPaddingValue);
    }

    public int getPixelPaddingValue() throws InvalidDataException {
        return this.getInt(BaseDicomTagNames.TAG_pixelPaddingValue);
    }

    public boolean hasPixelPaddingRange() {
        return this.existsDicomElement(BaseDicomTagNames.TAG_pixelPaddingRangeLimit);
    }

    public int getPixelPaddingRange() throws InvalidDataException {
        return this.getInt(BaseDicomTagNames.TAG_pixelPaddingRangeLimit);
    }

    public boolean isInPixelRange(aaa aaa2) {
        aaa aaa3 = this.getMaxPixelRange();
        return aaa2.ac() <= aaa3.ac() && aaa2.ab() >= aaa3.ab();
    }

    public String getVisusReducedPixelFlag() {
        return this.getString(DicomTagNames.TAG_visusReducedPixelFlag);
    }

    public boolean isVisusReducedPixelFlag() {
        String string = this.getString(DicomTagNames.TAG_visusReducedPixelFlag);
        return string != null && string.equals("REDUCED");
    }

    public boolean isVisusNoPixelFlag() {
        if (this.cachedVisusNoPixelData == null) {
            String string = this.getString(DicomTagNames.TAG_visusReducedPixelFlag);
            if (string == null || !string.equals("NO_PIXEL")) {
                this.cachedVisusNoPixelData = Boolean.FALSE;
                return false;
            }
            this.cachedVisusNoPixelData = Boolean.TRUE;
            return true;
        }
        return this.cachedVisusNoPixelData;
    }

    public void setVisusReducedPixelFlag(com.visustt.dicomTk.ab.ar ar2) throws InvalidDataException {
        this.cachedVisusNoPixelData = Boolean.FALSE;
        this.setVisusReducedOrNoPixelFlag(ar2, "REDUCED");
    }

    public void setVisusNoPixelFlag(com.visustt.dicomTk.ab.ar ar2) throws InvalidDataException {
        this.cachedVisusNoPixelData = Boolean.TRUE;
        this.cachedVisusDICOMHeader = Boolean.FALSE;
        this.setVisusReducedOrNoPixelFlag(ar2, "NO_PIXEL");
    }

    private void setVisusReducedOrNoPixelFlag(com.visustt.dicomTk.ab.ar ar2, String string) throws InvalidDataException {
        this.insertDicomElement(new aam(DicomTagNames.TAG_visusReducedPixelFlag, string));
        this.insertDicomElement(new aap(DicomTagNames.TAG_visusDCMREDOriginalTS, ar2.aa()));
    }

    public void removeVisusNoPixelFlag() {
        this.cachedVisusNoPixelData = Boolean.FALSE;
        this.cachedVisusDICOMHeader = Boolean.FALSE;
        this.removeDicomElement(DicomTagNames.TAG_visusReducedPixelFlag);
    }

    public void setVisusDICOMHeaderFlag(com.visustt.dicomTk.ab.ar ar2) throws InvalidDataException {
        this.cachedVisusNoPixelData = Boolean.TRUE;
        this.cachedVisusDICOMHeader = Boolean.TRUE;
        this.setVisusReducedOrNoPixelFlag(ar2, "NO_PIXEL\\DCMHEADER");
    }

    public boolean isVisusDICOMHeaderFlag() {
        if (this.cachedVisusDICOMHeader == null) {
            String string = this.getString(DicomTagNames.TAG_visusReducedPixelFlag, 1);
            if (string == null || !string.equals("DCMHEADER")) {
                this.cachedVisusDICOMHeader = Boolean.FALSE;
                return false;
            }
            this.cachedVisusDICOMHeader = Boolean.TRUE;
            return true;
        }
        return this.cachedVisusDICOMHeader;
    }

    private static InvalidDataException a(InvalidDataException invalidDataException) {
        return invalidDataException;
    }
}

