/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk;

import com.visustt.dicomTk.BaseDicomTagNames;
import com.visustt.dicomTk.CommonDicomException;
import com.visustt.dicomTk.DicomElementList;
import com.visustt.dicomTk.DicomModule;
import com.visustt.dicomTk.DicomObject;
import com.visustt.dicomTk.DicomTag;
import com.visustt.dicomTk.DicomTagNames;
import com.visustt.dicomTk.ImagePixelModuleBasic;
import com.visustt.dicomTk.InvalidDataException;
import com.visustt.dicomTk.NoValidDicomObjectException;
import com.visustt.dicomTk.NoValidValueIndexException;
import com.visustt.dicomTk.UnsupportedDicomObjectException;
import com.visustt.dicomTk.UnsupportedTransferSyntaxException;
import com.visustt.dicomTk.data.DicomElement;
import com.visustt.dicomTk.data.TransferSyntaxValues;
import com.visustt.dicomTk.data.aac;
import com.visustt.dicomTk.data.aam;
import com.visustt.dicomTk.data.aan;
import com.visustt.dicomTk.data.aao;
import com.visustt.dicomTk.data.aap;
import com.visustt.dicomTk.data.al;
import com.visustt.dicomTk.data.ao;
import com.visustt.dicomTk.data.ar;
import com.visustt.dicomTk.data.au;
import com.visustt.dicomTk.data.av;
import com.visustt.dicomTk.data.ax;
import com.visustt.dicomTk.imageplane.aa;
import com.visustt.dicomTk.imaging.ab.ac;
import com.visustt.dicomTk.imaging.ab.ah;
import com.visustt.dicomTk.imaging.ab.ai;
import com.visustt.dicomTk.imaging.ab.ak;
import com.visustt.dicomTk.imaging.ag;
import com.visustt.dicomTk.util.DicomWindow;
import com.visustt.dicomTk.util.aaa;
import com.visustt.dicomTk.util.aaf;
import com.visustt.dicomTk.util.aq;
import com.visustt.dicomTk.util.az;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.aj;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Date;

public class ImageModule
extends ImagePixelModuleBasic {
    protected static Logger logger = LoggerFactory.getInstance("jx.dicomTk");
    private static String[] nullStringArray = new String[0];
    private static byte[] nullByteArray = new byte[0];
    private Boolean cachedMonochrome1 = null;
    private Integer cachedNumberOfFrames = null;
    private Integer realNumberOfFrames = null;
    private boolean imagerPixelSpacingUsedWithoutMagnificationFactor = false;

    public ImageModule(DicomElementList dicomElementList) {
        super(dicomElementList);
    }

    public ImageModule() {
    }

    public ImageModule(DicomModule dicomModule) {
        super(dicomModule);
    }

    public String getSOPInstanceUID() {
        return this.getString(BaseDicomTagNames.TAG_sopInstanceUID);
    }

    public void setSOPInstanceUID(String string) throws InvalidDataException {
        this.insertDicomElement(new aap(BaseDicomTagNames.TAG_sopInstanceUID, string));
    }

    public String getSOPClassUID() {
        return this.getString(BaseDicomTagNames.TAG_sopClassUID);
    }

    public String getModality() {
        return this.getString(BaseDicomTagNames.TAG_modality);
    }

    public int getImageNumber() {
        block4: {
            aao aao2 = (aao)this.getDicomElement(BaseDicomTagNames.TAG_instanceNumber);
            try {
                String string;
                block5: {
                    if (aao2 == null) break block4;
                    string = aao2.ac();
                    try {
                        if (string != null && string.length() != 0) break block5;
                    }
                    catch (Exception exception) {
                        throw ImageModule.a(exception);
                    }
                    return 0;
                }
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    public int getAquisitionNumber() {
        aao aao2 = (aao)this.getDicomElement(BaseDicomTagNames.TAG_acquisitionNumber);
        try {
            if (aao2 != null) {
                String string = aao2.ac();
                return Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            return 0;
        }
        return 0;
    }

    public Date getAcquisitionDate() {
        return this.getDate(BaseDicomTagNames.TAG_acquisitionDate);
    }

    public Date getAcquisitionTime() {
        return this.getDate(BaseDicomTagNames.TAG_acquisitionTime);
    }

    public Date getAcquisitionDateTime() {
        return this.getDate(BaseDicomTagNames.TAG_acquisitionDateTime);
    }

    public void setImageNumber(int n) {
        aao aao2 = new aao(BaseDicomTagNames.TAG_instanceNumber, n);
        this.insertDicomElement(aao2);
    }

    public int getTemporalPositionIdentifier() {
        block5: {
            aao aao2 = (aao)this.getDicomElement(BaseDicomTagNames.TAG_temporalPositionIdentifier);
            try {
                block6: {
                    try {
                        if (aao2 == null) break block5;
                        if (aao2.ac() != null) break block6;
                    }
                    catch (Exception exception) {
                        throw ImageModule.a(exception);
                    }
                    return 0;
                }
                if (aao2.ac().equals("")) {
                    return 0;
                }
                return Integer.parseInt(aao2.ac());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    public boolean isSigmoid() {
        block4: {
            String string = this.getString(BaseDicomTagNames.TAG_voilutFunction);
            try {
                try {
                    if (string == null || !string.equals("SIGMOID")) break block4;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
        }
        return false;
    }

    public int getNumberOfTemporalPositions() {
        block5: {
            aao aao2 = (aao)this.getDicomElement(BaseDicomTagNames.TAG_numberOfTemporalPositions);
            try {
                block6: {
                    try {
                        if (aao2 == null) break block5;
                        if (aao2.ac() != null) break block6;
                    }
                    catch (Exception exception) {
                        throw ImageModule.a(exception);
                    }
                    return 0;
                }
                if (aao2.ac().equals("")) {
                    return 0;
                }
                return Integer.parseInt(aao2.ac());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    public boolean imageContainsPixelSpacing() {
        double d;
        double d2;
        block15: {
            DicomElement dicomElement;
            block14: {
                dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_pixelSpacing);
                try {
                    try {
                        if (dicomElement != null && dicomElement instanceof aan) break block14;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw ImageModule.a(numberFormatException);
                    }
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
            }
            aan aan2 = (aan)dicomElement;
            try {
                if (aan2.getValueMultiplication() != 2) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
            d2 = this.getPixelSpacingX();
            d = this.getPixelSpacingY();
            try {
                try {
                    if (!(d2 <= 0.0) && !(d <= 0.0)) break block15;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
        }
        try {
            if (Math.abs(d2 - d) > 10000.0) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getPixelSpacingX() {
        DicomElement dicomElement;
        block6: {
            dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_pixelSpacing);
            if (dicomElement == null) return 1.0;
            try {
                if (dicomElement instanceof aan) break block6;
                return 1.0;
                catch (Exception exception) {
                    throw ImageModule.a(exception);
                }
            }
            catch (Exception exception) {
                throw ImageModule.a(exception);
            }
        }
        aan aan2 = (aan)dicomElement;
        try {
            return Double.parseDouble(aan2.aa(1));
        }
        catch (Exception exception) {
            return 1.0;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getPixelSpacingY() {
        DicomElement dicomElement;
        block6: {
            dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_pixelSpacing);
            if (dicomElement == null) return 1.0;
            try {
                if (dicomElement instanceof aan) break block6;
                return 1.0;
                catch (Exception exception) {
                    throw ImageModule.a(exception);
                }
            }
            catch (Exception exception) {
                throw ImageModule.a(exception);
            }
        }
        aan aan2 = (aan)dicomElement;
        try {
            return Double.parseDouble(aan2.aa(0));
        }
        catch (Exception exception) {
            return 1.0;
        }
    }

    /*
     * Exception decompiling
     */
    public Point2D.Double getRealModalityDependentPixelSpacing() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 21[TRYBLOCK] [20, 19, 23 : 496->506)] com.visustt.dicomTk.NoValidValueIndexException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void handleUltraSound(Point2D.Double double_) {
        boolean bl;
        try {
            bl = this.hasValidSpacingDefined();
        }
        catch (InvalidDataException invalidDataException) {
            bl = false;
        }
        if (bl) {
            try {
                av av2 = (av)this.getDicomElement(BaseDicomTagNames.TAG_sequenceOfUltrasoundRegions);
                DicomElementList dicomElementList = av2.getValueAsSequence(0);
                DicomElement dicomElement = dicomElementList.getDicomElement(BaseDicomTagNames.TAG_physicalDeltaX);
                try {
                    if (dicomElement != null) {
                        this.setUltraSoundPixelSpacing(double_, dicomElementList, dicomElement);
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                double_.setLocation(-1.0, -1.0);
            }
        } else {
            double_.setLocation(-1.0, -1.0);
        }
    }

    boolean hasValidSpacingDefined() throws InvalidDataException {
        return ag.aa(this.contents);
    }

    void setUltraSoundPixelSpacing(Point2D.Double double_, DicomElementList dicomElementList, DicomElement dicomElement) throws NoValidValueIndexException {
        double d = dicomElement.getValueAsDouble(0);
        DicomElement dicomElement2 = dicomElementList.getDicomElement(BaseDicomTagNames.TAG_physicalDeltaY);
        double d2 = dicomElement2.getValueAsDouble(0);
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        double_.setLocation(d * 10.0, d2 * 10.0);
    }

    /*
     * Loose catch block
     */
    double specialGeHandlingToIgnoreDicomMagnificationFactor(String string, aa aa10, double d) {
        block22: {
            boolean bl;
            boolean bl2;
            boolean bl3;
            block21: {
                block20: {
                    bl3 = "MG".equals(string);
                    DicomElement dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_manufacturer);
                    if (dicomElement == null) break block20;
                    try {
                        block23: {
                            if (dicomElement.getValues() == null) break block20;
                            break block23;
                            catch (NoValidValueIndexException noValidValueIndexException) {
                                throw ImageModule.a(noValidValueIndexException);
                            }
                        }
                        bl2 = dicomElement.getValues()[0].equalsIgnoreCase("GE MEDICAL SYSTEMS");
                        break block21;
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw ImageModule.a(noValidValueIndexException);
                    }
                }
                bl2 = false;
            }
            boolean bl4 = bl2;
            try {
                bl = d > 1.0;
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw ImageModule.a(noValidValueIndexException);
            }
            boolean bl5 = bl;
            if (!bl3) break block22;
            try {
                block24: {
                    if (!bl4) break block22;
                    break block24;
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw ImageModule.a(noValidValueIndexException);
                    }
                }
                if (!bl5) break block22;
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw ImageModule.a(noValidValueIndexException);
            }
            DicomElement dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_detectorElementSpacing);
            DicomElement dicomElement2 = this.getDicomElement(BaseDicomTagNames.TAG_imagerPixelSpacing);
            try {
                if (dicomElement == null || dicomElement2 == null) break block22;
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw ImageModule.a(noValidValueIndexException);
            }
            int n = dicomElement.getValueMultiplication();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3;
                int n4;
                double d2 = 0.0;
                double d3 = 0.0;
                try {
                    d2 = dicomElement.getValueAsDouble(i);
                    d3 = dicomElement2.getValueAsDouble(i);
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    logger.error((Object)noValidValueIndexException, noValidValueIndexException);
                }
                double d4 = Math.abs(d2 - d3);
                try {
                    n4 = n2;
                    n3 = d3 / d4 < 10.0 ? 1 : 0;
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw ImageModule.a(noValidValueIndexException);
                }
                n2 = n4 + n3;
            }
            if (n2 == n) {
                aan aan2 = new aan(BaseDicomTagNames.TAG_estimatedRadiographicMagnificationFactor);
                try {
                    aan2.aa(new double[]{1.0});
                    aa10.insertDicomElement(aan2);
                }
                catch (InvalidDataException invalidDataException) {
                    logger.error((Object)invalidDataException, invalidDataException);
                }
                d = 1.0;
            }
        }
        return d;
    }

    public boolean imageContainsPixelAspectRatio() {
        double d;
        double d2;
        block16: {
            DicomElement dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_pixelAspectRatio);
            try {
                if (dicomElement == null) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
            try {
                if (!(dicomElement instanceof aao)) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
            aao aao2 = (aao)dicomElement;
            try {
                if (aao2.getValueMultiplication() != 2) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
            d2 = this.getPixelAspectRatioX();
            d = this.getPixelAspectRatioY();
            try {
                try {
                    if (!(d2 <= 0.0) && !(d <= 0.0)) break block16;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
        }
        try {
            if (Math.abs(d2 - d) > 10000.0) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return true;
    }

    public double getPixelAspectRatioX() {
        aao aao2 = (aao)this.getDicomElement(BaseDicomTagNames.TAG_pixelAspectRatio);
        try {
            if (aao2 == null) {
                return 1.0;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            return aao2.getValueAsDouble(1);
        }
        catch (Exception exception) {
            return 1.0;
        }
    }

    public double getPixelAspectRatioY() {
        aao aao2 = (aao)this.getDicomElement(BaseDicomTagNames.TAG_pixelAspectRatio);
        try {
            if (aao2 == null) {
                return 1.0;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            return aao2.getValueAsDouble(0);
        }
        catch (Exception exception) {
            return 1.0;
        }
    }

    public int getBitsRequiredForPixelData() {
        int n;
        int n2 = this.getSmallestPixelValue();
        int n3 = this.getLargestPixelValue();
        try {
            n = this.isPixelRepresentationSigned() ? 1 : 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        int n4 = n;
        int n5 = Math.max(Math.abs(n2 + 1), Math.abs(n3));
        while (n5 > 0) {
            n5 >>= 1;
            ++n4;
        }
        if (n4 == 0) {
            n4 = 1;
        }
        return n4;
    }

    public boolean pixelDataIsByteArray() {
        DicomElement dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_pixelData);
        try {
            if (dicomElement instanceof ar) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return false;
    }

    public boolean pixelDataIsShortArray() {
        DicomElement dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_pixelData);
        try {
            if (dicomElement instanceof au) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return false;
    }

    public boolean visusPreviewDataIsShortArray() {
        DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_visusDICOMpre_previewFrame);
        try {
            if (dicomElement instanceof au) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return false;
    }

    public int getSamplesPerPixelAsIntCorrect() {
        try {
            Integer n = this.getInteger(BaseDicomTagNames.TAG_samplesPerPixel);
            if (n != null) {
                return n;
            }
        }
        catch (Exception exception) {
            return 1;
        }
        return 1;
    }

    public boolean isGrayscaleImage() {
        block7: {
            String string = this.getPhotometricInterpretation();
            try {
                if (string == null) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
            try {
                try {
                    if (!string.toUpperCase().equals("MONOCHROME1") && !string.toUpperCase().equals("MONOCHROME2")) break block7;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
        }
        return false;
    }

    public boolean isColor() {
        block16: {
            boolean bl;
            block19: {
                block18: {
                    String string = this.getPhotometricInterpretation();
                    try {
                        block17: {
                            try {
                                try {
                                    try {
                                        try {
                                            try {
                                                try {
                                                    try {
                                                        if (string == null) break block16;
                                                        if (string.equals("RGB")) break block17;
                                                    }
                                                    catch (NumberFormatException numberFormatException) {
                                                        throw ImageModule.a(numberFormatException);
                                                    }
                                                    if (string.equals("PALETTE COLOR")) break block17;
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    throw ImageModule.a(numberFormatException);
                                                }
                                                if (string.equals("YBR_FULL")) break block17;
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                throw ImageModule.a(numberFormatException);
                                            }
                                            if (string.equals("YBR_FULL_422")) break block17;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            throw ImageModule.a(numberFormatException);
                                        }
                                        if (string.equals("YBR_PARTIAL_422")) break block17;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        throw ImageModule.a(numberFormatException);
                                    }
                                    if (string.equals("YBR_ICT")) break block17;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw ImageModule.a(numberFormatException);
                                }
                                if (!string.equals("YBR_RCT")) break block18;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw ImageModule.a(numberFormatException);
                            }
                        }
                        bl = true;
                        break block19;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw ImageModule.a(numberFormatException);
                    }
                }
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public boolean isColorPalette() {
        String string = this.getPhotometricInterpretation();
        try {
            if (string != null) {
                return string.equals("PALETTE COLOR");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return false;
    }

    public boolean isYBR_FULL() {
        String string = this.getPhotometricInterpretation();
        try {
            if (string != null) {
                return string.equals("YBR_FULL");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return false;
    }

    public boolean isYBR_ICT() {
        String string = this.getPhotometricInterpretation();
        try {
            if (string != null) {
                return string.equals("YBR_ICT");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return false;
    }

    public boolean isYBR_RCT() {
        String string = this.getPhotometricInterpretation();
        try {
            if (string != null) {
                return string.equals("YBR_RCT");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return false;
    }

    public boolean isYBR_FULL_422() {
        String string = this.getPhotometricInterpretation();
        try {
            if (string != null) {
                return string.equals("YBR_FULL_422");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return false;
    }

    public boolean isRGBImage() {
        String string = this.getPhotometricInterpretation();
        try {
            if (string == null) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        try {
            if (string.toUpperCase().equals("RGB")) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        try {
            if (string.toUpperCase().startsWith("YBR")) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return false;
    }

    public boolean isYBRImage() {
        String string = this.getPhotometricInterpretation();
        try {
            if (string.toUpperCase().startsWith("YBR")) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return false;
    }

    public boolean isMonochrome1() {
        block6: {
            if (this.cachedMonochrome1 == null) {
                block5: {
                    String string = this.getPhotometricInterpretation();
                    try {
                        try {
                            if (string == null || !string.toUpperCase().equals("MONOCHROME1")) break block5;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw ImageModule.a(numberFormatException);
                        }
                        this.cachedMonochrome1 = Boolean.TRUE;
                        break block6;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw ImageModule.a(numberFormatException);
                    }
                }
                this.cachedMonochrome1 = Boolean.FALSE;
            }
        }
        return this.cachedMonochrome1;
    }

    public int getImageWidth() {
        try {
            Integer n = this.getInteger(BaseDicomTagNames.TAG_columns);
            if (n != null) {
                return n;
            }
        }
        catch (Exception exception) {
            return 1;
        }
        return 1;
    }

    public int getImageHeight() {
        if (this.existsDicomElement(BaseDicomTagNames.TAG_rows)) {
            try {
                Integer n = this.getInteger(BaseDicomTagNames.TAG_rows);
                if (n != null) {
                    return n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    public void setImageWidth(int n) throws InvalidDataException {
        al al2 = new al(BaseDicomTagNames.TAG_columns, n);
        this.insertDicomElement(al2);
    }

    public void setImageHeight(int n) throws InvalidDataException {
        al al2 = new al(BaseDicomTagNames.TAG_rows, n);
        this.insertDicomElement(al2);
    }

    public int getNumberOfWindowPresets() {
        aan aan2 = (aan)this.getDicomElement(BaseDicomTagNames.TAG_windowCenter);
        aan aan3 = (aan)this.getDicomElement(BaseDicomTagNames.TAG_windowWidth);
        try {
            if (aan2 == null) {
                return 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        try {
            if (aan3 == null) {
                return 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return aan2.getValueMultiplication();
    }

    public double getWindowWidthPreset(int n) {
        aan aan2 = (aan)this.getDicomElement(BaseDicomTagNames.TAG_windowWidth);
        try {
            if (n >= aan2.getValueMultiplication()) {
                return -1.0;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            return Double.parseDouble(aan2.aa(n));
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public double getFrameTime() {
        if (this.existsDicomElement(BaseDicomTagNames.TAG_frameTime)) {
            aan aan2 = (aan)this.getDicomElement(BaseDicomTagNames.TAG_frameTime);
            try {
                return Double.parseDouble(aan2.ac());
            }
            catch (Exception exception) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public int getRecommendedDisplayFrameRate() {
        if (this.existsDicomElement(BaseDicomTagNames.TAG_recommendedDisplayFrameRate)) {
            aao aao2 = (aao)this.getDicomElement(BaseDicomTagNames.TAG_recommendedDisplayFrameRate);
            try {
                return Integer.parseInt(aao2.ac());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    public float getRecommendedDisplayFrameRateInFloat() {
        if (this.existsDicomElement(BaseDicomTagNames.TAG_recommendedDisplayFrameRateInFloat)) {
            ao ao2 = (ao)this.getDicomElement(BaseDicomTagNames.TAG_recommendedDisplayFrameRateInFloat);
            try {
                return ao2.aa();
            }
            catch (Exception exception) {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public int getCineRate() {
        if (this.existsDicomElement(BaseDicomTagNames.TAG_cineRate)) {
            aao aao2 = (aao)this.getDicomElement(BaseDicomTagNames.TAG_cineRate);
            try {
                return Integer.parseInt(aao2.ac());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    public void addWindowLevelPresets(DicomWindow dicomWindow) {
        this.addWindowLevelPresets(dicomWindow.getCenter(), dicomWindow.getWidth());
    }

    public void setWindowLevelPresets(DicomWindow dicomWindow) {
        try {
            aan aan2 = new aan(BaseDicomTagNames.TAG_windowCenter, dicomWindow.getCenter());
            aan aan3 = new aan(BaseDicomTagNames.TAG_windowWidth, dicomWindow.getWidth());
            this.insertDicomElement(aan2);
            this.insertDicomElement(aan3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWindowExplanationPreset(String string) {
        try {
            aac aac2 = new aac(BaseDicomTagNames.TAG_windowCenterWidthExplanation, string);
            this.insertDicomElement(aac2);
        }
        catch (InvalidDataException invalidDataException) {
            logger.error((Object)invalidDataException, invalidDataException);
        }
    }

    public void setWindowExplanationPreset(String[] stringArray) {
        try {
            aac aac2 = new aac(BaseDicomTagNames.TAG_windowCenterWidthExplanation, stringArray);
            this.insertDicomElement(aac2);
        }
        catch (InvalidDataException invalidDataException) {
            logger.error((Object)invalidDataException, invalidDataException);
        }
    }

    public void addWindowLevelPresets(double d, double d2) {
        block17: {
            String[] stringArray;
            Object object;
            block16: {
                aan aan2 = (aan)this.getDicomElement(BaseDicomTagNames.TAG_windowCenter);
                try {
                    if (aan2 == null) {
                        aan2 = new aan(BaseDicomTagNames.TAG_windowCenter, (float)d);
                        this.insertDicomElement(aan2);
                        break block16;
                    }
                    object = (String[])aan2.ab();
                    stringArray = null;
                    if (object == null) {
                        stringArray = nullStringArray;
                        object = nullStringArray;
                    } else {
                        stringArray = new String[((String[])object).length + 1];
                    }
                    stringArray[0] = String.valueOf(d);
                    try {
                        for (int i = 1; i < stringArray.length; ++i) {
                            stringArray[i] = object[i - 1];
                        }
                    }
                    catch (Exception exception) {
                        throw ImageModule.a(exception);
                    }
                    aan2.aa(stringArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = (aan)this.getDicomElement(BaseDicomTagNames.TAG_windowWidth);
            try {
                if (object == null) {
                    object = new aan(BaseDicomTagNames.TAG_windowWidth, (float)d2);
                    this.insertDicomElement((DicomElement)object);
                    break block17;
                }
                stringArray = (String[])((ax)object).ab();
                String[] stringArray2 = null;
                if (stringArray == null) {
                    stringArray = nullStringArray;
                    stringArray2 = nullStringArray;
                } else {
                    stringArray2 = new String[stringArray.length + 1];
                }
                stringArray2[0] = String.valueOf(d2);
                try {
                    for (int i = 1; i < stringArray2.length; ++i) {
                        stringArray2[i] = stringArray[i - 1];
                    }
                }
                catch (Exception exception) {
                    throw ImageModule.a(exception);
                }
                ((ax)object).aa(stringArray2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public double getWindowLevelPreset(int n) {
        aan aan2 = (aan)this.getDicomElement(BaseDicomTagNames.TAG_windowCenter);
        try {
            if (n >= aan2.getValueMultiplication()) {
                return -1.0;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            return Double.parseDouble(aan2.aa(n));
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public String getWindowExplanationPreset(int n) {
        aac aac2 = (aac)this.getDicomElement(BaseDicomTagNames.TAG_windowCenterWidthExplanation);
        try {
            if (aac2 == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            if (n >= aac2.getValueMultiplication()) {
                return null;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            return aac2.aa(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getSmallestPixelValue() {
        DicomElement dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_smallestImagePixelValue);
        try {
            if (dicomElement == null) {
                return -1;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            if (dicomElement instanceof al) {
                return ((al)dicomElement).aa();
            }
            return ((com.visustt.dicomTk.data.ak)dicomElement).aa();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getLargestPixelValue() {
        DicomElement dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_largestImagePixelValue);
        try {
            if (dicomElement == null) {
                return -1;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            if (dicomElement instanceof al) {
                return ((al)dicomElement).aa();
            }
            return ((com.visustt.dicomTk.data.ak)dicomElement).aa();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    /*
     * Loose catch block
     */
    public boolean existsPixelAspectRatio() {
        try {
            block6: {
                boolean bl;
                block8: {
                    block7: {
                        DicomElement dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_pixelAspectRatio);
                        if (dicomElement == null) break block6;
                        try {
                            block9: {
                                if (dicomElement.getValueMultiplication() != 2) break block7;
                                break block9;
                                catch (Exception exception) {
                                    throw ImageModule.a(exception);
                                }
                            }
                            bl = true;
                            break block8;
                        }
                        catch (Exception exception) {
                            throw ImageModule.a(exception);
                        }
                    }
                    bl = false;
                }
                return bl;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setPixelAspectRatio(int n, int n2) throws InvalidDataException {
        aao aao2 = new aao(BaseDicomTagNames.TAG_pixelAspectRatio);
        aao2.aa(new String[]{Integer.toString(n2), Integer.toString(n)});
        this.insertDicomElement(aao2);
    }

    public int getVisusLargestPixelValue() {
        return this.getUS_SSAsInt(DicomTagNames.TAG_visusLargestImagePixelValue);
    }

    public int getVisusSmallestPixelValue() {
        return this.getUS_SSAsInt(DicomTagNames.TAG_visusSmallestImagePixelValue);
    }

    public int getVisusOptimalLargestPixelValue() {
        return this.getUS_SSAsInt(DicomTagNames.TAG_visusOptimalLargestImagePixelValue);
    }

    public int getVisusOptimalSmallestPixelValue() {
        return this.getUS_SSAsInt(DicomTagNames.TAG_visusOptimalSmallestImagePixelValue);
    }

    public String getVisusImagePixelValueVersion() {
        return this.getString(DicomTagNames.TAG_visusImagePixelValueVersion);
    }

    public boolean hasVisusPixelRange() {
        boolean bl;
        block11: {
            block10: {
                try {
                    try {
                        try {
                            try {
                                try {
                                    if (!this.existsDicomElement(DicomTagNames.TAG_visusLargestImagePixelValue) || !this.existsDicomElement(DicomTagNames.TAG_visusSmallestImagePixelValue)) break block10;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw ImageModule.a(numberFormatException);
                                }
                                if (!this.existsDicomElement(DicomTagNames.TAG_visusOptimalLargestImagePixelValue)) break block10;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw ImageModule.a(numberFormatException);
                            }
                            if (!this.existsDicomElement(DicomTagNames.TAG_visusOptimalSmallestImagePixelValue)) break block10;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw ImageModule.a(numberFormatException);
                        }
                        if (!this.existsDicomElement(DicomTagNames.TAG_visusImagePixelValueVersion)) break block10;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw ImageModule.a(numberFormatException);
                    }
                    bl = true;
                    break block11;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public aaa getVisusPixelRange() {
        return new aaa(this.getVisusSmallestPixelValue(), this.getVisusOptimalSmallestPixelValue(), this.getVisusLargestPixelValue(), this.getVisusOptimalLargestPixelValue());
    }

    public void setVisusPixelRangeInformation(aaa aaa2) throws InvalidDataException {
        block3: {
            block2: {
                try {
                    if (!this.isPixelRepresentationSigned()) break block2;
                    this.insertDicomElement(new com.visustt.dicomTk.data.ak(DicomTagNames.TAG_visusLargestImagePixelValue, aaa2.ac()));
                    this.insertDicomElement(new com.visustt.dicomTk.data.ak(DicomTagNames.TAG_visusSmallestImagePixelValue, aaa2.ab()));
                    this.insertDicomElement(new com.visustt.dicomTk.data.ak(DicomTagNames.TAG_visusOptimalLargestImagePixelValue, aaa2.ae()));
                    this.insertDicomElement(new com.visustt.dicomTk.data.ak(DicomTagNames.TAG_visusOptimalSmallestImagePixelValue, aaa2.ad()));
                    break block3;
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
            }
            this.insertDicomElement(new al(DicomTagNames.TAG_visusLargestImagePixelValue, aaa2.ac()));
            this.insertDicomElement(new al(DicomTagNames.TAG_visusSmallestImagePixelValue, aaa2.ab()));
            this.insertDicomElement(new al(DicomTagNames.TAG_visusOptimalLargestImagePixelValue, aaa2.ae()));
            this.insertDicomElement(new al(DicomTagNames.TAG_visusOptimalSmallestImagePixelValue, aaa2.ad()));
        }
        this.insertDicomElement(new aac(DicomTagNames.TAG_visusImagePixelValueVersion, "1.0"));
    }

    public void setLargestPixelValue(int n) throws InvalidDataException {
        block3: {
            block2: {
                try {
                    if (!this.isPixelRepresentationSigned()) break block2;
                    this.insertDicomElement(new com.visustt.dicomTk.data.ak(BaseDicomTagNames.TAG_largestImagePixelValue, n));
                    break block3;
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
            }
            this.insertDicomElement(new al(BaseDicomTagNames.TAG_largestImagePixelValue, n));
        }
    }

    public void setSmallestPixelValue(int n) throws InvalidDataException {
        block3: {
            block2: {
                try {
                    if (!this.isPixelRepresentationSigned()) break block2;
                    this.insertDicomElement(new com.visustt.dicomTk.data.ak(BaseDicomTagNames.TAG_smallestImagePixelValue, n));
                    break block3;
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
            }
            this.insertDicomElement(new al(BaseDicomTagNames.TAG_smallestImagePixelValue, n));
        }
    }

    public boolean isMultiframeImage() {
        boolean bl;
        int n = this.getNumberOfFrames();
        try {
            bl = n != 1;
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return bl;
    }

    public int getNumberOfFrames() {
        block6: {
            if (this.cachedNumberOfFrames == null) {
                aao aao2;
                block5: {
                    aao2 = (aao)this.getDicomElement(BaseDicomTagNames.TAG_numberOfFrames);
                    try {
                        if (aao2 != null) break block5;
                        this.cachedNumberOfFrames = 1;
                        break block6;
                    }
                    catch (Exception exception) {
                        throw ImageModule.a(exception);
                    }
                }
                try {
                    this.cachedNumberOfFrames = Integer.valueOf(aao2.ac());
                }
                catch (Exception exception) {
                    this.cachedNumberOfFrames = 1;
                }
            }
        }
        return this.cachedNumberOfFrames;
    }

    public void setNumberOfFrames(int n) throws InvalidDataException {
        this.realNumberOfFrames = this.cachedNumberOfFrames;
        this.cachedNumberOfFrames = null;
        this.insertDicomElement(new aao(BaseDicomTagNames.TAG_numberOfFrames, n));
    }

    public int getRealNumberOfFrames() {
        try {
            if (this.realNumberOfFrames != null) {
                return this.realNumberOfFrames;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return this.getNumberOfFrames();
    }

    public byte[] getPixelDataAsByteArray() {
        DicomElement dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_pixelData);
        try {
            if (dicomElement == null) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        try {
            if (dicomElement instanceof ar) {
                return ((ar)dicomElement).ab();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return null;
    }

    public byte[] convertPixelDataAsByteArray() {
        DicomElement dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_pixelData);
        try {
            if (dicomElement == null) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        try {
            if (dicomElement instanceof ar) {
                return ((ar)dicomElement).ab();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        short[] sArray = ((au)dicomElement).ab();
        byte[] byArray = new byte[2 * sArray.length];
        try {
            for (int i = 0; i < sArray.length; ++i) {
                byArray[2 * i] = (byte)(sArray[i] >> 8 & 0xFF);
                byArray[2 * i + 1] = (byte)(sArray[i] & 0xFF);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return byArray;
    }

    public short[] getPixelDataAsShortArray() {
        au au2 = (au)this.getDicomElement(BaseDicomTagNames.TAG_pixelData);
        try {
            if (au2 != null) {
                return au2.ab();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getFrameAsByteArray(int n) {
        block9: {
            if (this.getNumberOfFrames() <= 1) return null;
            try {
                if (n < this.getNumberOfFrames()) break block9;
                return null;
                catch (Exception exception) {
                    throw ImageModule.a(exception);
                }
            }
            catch (Exception exception) {
                throw ImageModule.a(exception);
            }
        }
        ar ar2 = (ar)this.getDicomElement(BaseDicomTagNames.TAG_pixelData);
        try {
            if (ar2 == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            byte[] byArray = ar2.ab();
            byte[] byArray2 = new byte[byArray.length / this.getNumberOfFrames()];
            System.arraycopy(byArray, byArray2.length * n, byArray2, 0, byArray2.length);
            return byArray2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addPixelDataEmbedded(byte[] byArray) {
        av av2 = null;
        DicomElement dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_pixelData);
        av2 = dicomElement instanceof av ? (av)dicomElement : new av(BaseDicomTagNames.TAG_pixelData);
        try {
            if (av2.ab() == 0) {
                av2.ad().aa(nullByteArray);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        av2.ad().aa(byArray);
        this.insertDicomElement(av2);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public short[] getFrameAsShortArray(int n) {
        block9: {
            if (this.getNumberOfFrames() <= 1) return null;
            try {
                if (n < this.getNumberOfFrames()) break block9;
                return null;
                catch (Exception exception) {
                    throw ImageModule.a(exception);
                }
            }
            catch (Exception exception) {
                throw ImageModule.a(exception);
            }
        }
        au au2 = (au)this.getDicomElement(BaseDicomTagNames.TAG_pixelData);
        try {
            if (au2 == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            short[] sArray = au2.ab();
            short[] sArray2 = new short[sArray.length / this.getNumberOfFrames()];
            System.arraycopy(sArray, sArray2.length * n, sArray2, 0, sArray2.length);
            return sArray2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] getSampleAndFrameAsByteArray(int n, int n2) {
        int n3 = this.getNumberOfFrames();
        int n4 = this.getSamplesPerPixelAsIntCorrect();
        try {
            if (n >= n3) {
                return null;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            if (n2 >= n4) {
                return null;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        ar ar2 = (ar)this.getDicomElement(BaseDicomTagNames.TAG_pixelData);
        try {
            if (ar2 == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        byte[] byArray = null;
        try {
            byArray = ar2.ab();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (byArray == null) {
                return new byte[0];
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        int n5 = byArray.length / n3;
        int n6 = n5 / n4;
        int n7 = this.getPlanarConfigurationAsInt();
        byte[] byArray2 = new byte[n6];
        int n8 = n5 * n;
        if (n7 == 0) {
            try {
                for (int i = 0; i < n6; ++i) {
                    byArray2[i] = byArray[n8 + i * n4 + n2];
                }
            }
            catch (Exception exception) {
                throw ImageModule.a(exception);
            }
        }
        try {
            if (n7 == 1) {
                System.arraycopy(byArray, n8 + n2 * n6, byArray2, 0, n6);
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        ar2 = null;
        byArray = null;
        return byArray2;
    }

    public short[] getSampleAndFrameAsShortArray(int n, int n2) {
        int n3 = this.getNumberOfFrames();
        int n4 = this.getSamplesPerPixelAsIntCorrect();
        try {
            if (n >= n3) {
                return null;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            if (n2 >= n4) {
                return null;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        au au2 = (au)this.getDicomElement(BaseDicomTagNames.TAG_pixelData);
        try {
            if (au2 == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        short[] sArray = null;
        try {
            sArray = au2.ab();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (sArray == null) {
                return new short[0];
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        int n5 = sArray.length / n3;
        int n6 = n5 / n4;
        short[] sArray2 = new short[n6];
        int n7 = n5 * n;
        System.arraycopy(sArray, n7 + n2 * n6, sArray2, 0, n6);
        sArray = null;
        return sArray2;
    }

    public void convertByteDataToShortData() {
        try {
            if (this.pixelDataIsShortArray()) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        au au2 = new au(BaseDicomTagNames.TAG_pixelData);
        ar ar2 = (ar)this.getDicomElement(BaseDicomTagNames.TAG_pixelData);
        byte[] byArray = null;
        byArray = ar2.ab();
        short[] sArray = new short[byArray.length];
        if (!this.isPixelRepresentationSigned()) {
            try {
                for (int i = 0; i < byArray.length; ++i) {
                    sArray[i] = (short)(byArray[i] & 0xFF);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
        }
        try {
            for (int i = 0; i < byArray.length; ++i) {
                sArray[i] = byArray[i];
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        au2.aa(sArray);
        byArray = null;
        sArray = null;
        ar2.kill();
        this.removeDicomElement(ar2.getDicomTag());
        ar2 = null;
        this.insertDicomElement(au2);
        au2 = null;
    }

    public int getPlanarConfigurationAsInt() {
        try {
            Integer n = this.getInteger(BaseDicomTagNames.TAG_planarConfiguration);
            if (n != null) {
                return n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public boolean existsVOILUT() {
        return this.existsDicomElement(BaseDicomTagNames.TAG_voilutSequence);
    }

    public int getNumberOfVOILUTs() {
        av av2 = (av)this.getDicomElement(BaseDicomTagNames.TAG_voilutSequence);
        try {
            if (av2 == null) {
                return 0;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            block10: {
                DicomElementList dicomElementList;
                block9: {
                    dicomElementList = av2.aa(0);
                    DicomElement dicomElement = dicomElementList.getDicomElement(BaseDicomTagNames.TAG_lutDescriptor);
                    try {
                        if (dicomElement != null && dicomElement.getValueMultiplication() != 0) break block9;
                    }
                    catch (Exception exception) {
                        throw ImageModule.a(exception);
                    }
                    return 0;
                }
                DicomElement dicomElement = dicomElementList.getDicomElement(BaseDicomTagNames.TAG_lutData);
                try {
                    if (dicomElement != null && dicomElement.getValueMultiplication() != 0) break block10;
                }
                catch (Exception exception) {
                    throw ImageModule.a(exception);
                }
                return 0;
            }
            return av2.getValueMultiplication();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public ak getVOILUTAsObject(int n) throws InvalidDataException {
        ak ak2 = new ak(this.getNameOfVOILUT(n), this.getVOILUTAsArray(n), this.getFirstMappedValueOfVOILUT(n), this.getVOILUTbitsUsed(n));
        return ak2;
    }

    private int getFirstMappedValueOfVOILUT(int n) throws InvalidDataException {
        av av2 = (av)this.getDicomElement(BaseDicomTagNames.TAG_voilutSequence);
        try {
            if (av2 == null) {
                return -1;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ImageModule.a(invalidDataException);
        }
        try {
            if (n >= av2.getValueMultiplication()) {
                return -1;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ImageModule.a(invalidDataException);
        }
        DicomElementList dicomElementList = av2.aa(n);
        DicomElement dicomElement = dicomElementList.getDicomElement(BaseDicomTagNames.TAG_lutDescriptor);
        int n2 = dicomElement.getValueAsInt(1);
        if (this.isPixelRepresentationSigned()) {
            n2 = (short)n2;
        }
        return n2;
    }

    public boolean containsImageOverlays() {
        for (int i = 0; i < 32; i += 2) {
            int n = (24576 + i << 16) + 16;
            DicomElement dicomElement = this.contents.getDicomElement(n);
            try {
                if (dicomElement == null) {
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
            int n2 = (24576 + i << 16) + 12288;
            DicomElement dicomElement2 = this.contents.getDicomElement(n2);
            try {
                if (dicomElement2 != null) continue;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
        }
        return false;
    }

    public boolean containsImageOverlaysBeforePixelData() throws InvalidDataException {
        int n = this.getBitsStoredAsInt(-1);
        for (int i = 0; i < 32; i += 2) {
            int n2 = (24576 + i << 16) + 16;
            DicomElement dicomElement = this.contents.getDicomElement(n2);
            try {
                if (dicomElement == null) {
                    break;
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw ImageModule.a(invalidDataException);
            }
            int n3 = (24576 + i << 16) + 12288;
            DicomElement dicomElement2 = this.contents.getDicomElement(n3);
            if (dicomElement2 != null) continue;
            int n4 = this.getInt(new DicomTag((24576 + i << 16) + 258));
            try {
                if (n4 >= n) continue;
                return true;
            }
            catch (InvalidDataException invalidDataException) {
                throw ImageModule.a(invalidDataException);
            }
        }
        return false;
    }

    public boolean containsOverlaysIn6000() {
        for (int i = 0; i < 32; i += 2) {
            int n = (24576 + i << 16) + 16;
            DicomElement dicomElement = this.contents.getDicomElement(n);
            try {
                try {
                    if (dicomElement == null || dicomElement.getValueMultiplication() == 0) {
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
            int n2 = (24576 + i << 16) + 16;
            DicomElement dicomElement2 = this.contents.getDicomElement(n2);
            try {
                try {
                    if (dicomElement2 == null || dicomElement2.getValueMultiplication() == 0) {
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
            int n3 = (24576 + i << 16) + 12288;
            DicomElement dicomElement3 = this.contents.getDicomElement(n3);
            try {
                try {
                    if (dicomElement3 == null || dicomElement3.getValueMultiplication() == 0) continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
        }
        return false;
    }

    private String getNameOfVOILUT(int n) throws NoValidValueIndexException {
        DicomElement dicomElement;
        block10: {
            av av2 = (av)this.getDicomElement(BaseDicomTagNames.TAG_voilutSequence);
            try {
                if (av2 == null) {
                    return null;
                }
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw ImageModule.a(noValidValueIndexException);
            }
            try {
                if (n >= av2.getValueMultiplication()) {
                    return null;
                }
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw ImageModule.a(noValidValueIndexException);
            }
            DicomElementList dicomElementList = av2.aa(n);
            dicomElement = dicomElementList.getDicomElement(BaseDicomTagNames.TAG_lutExplanation);
            try {
                try {
                    if (dicomElement != null && dicomElement.getValueMultiplication() != 0) break block10;
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw ImageModule.a(noValidValueIndexException);
                }
                return "VOI LUT " + (n + 1);
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw ImageModule.a(noValidValueIndexException);
            }
        }
        String string = dicomElement.getValueAsString(0);
        return string;
    }

    private int[] getVOILUTAsArray(int n) throws InvalidDataException {
        return com.visustt.dicomTk.util.ax.aa(BaseDicomTagNames.TAG_voilutSequence, this, n);
    }

    private int getVOILUTbitsUsed(int n) throws InvalidDataException {
        av av2 = (av)this.getDicomElement(BaseDicomTagNames.TAG_voilutSequence);
        try {
            if (av2 == null) {
                return -1;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ImageModule.a(invalidDataException);
        }
        try {
            if (n >= av2.getValueMultiplication()) {
                return -1;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ImageModule.a(invalidDataException);
        }
        DicomElementList dicomElementList = av2.aa(n);
        DicomElement dicomElement = dicomElementList.getDicomElement(BaseDicomTagNames.TAG_lutDescriptor);
        int n2 = dicomElement.getValueAsInt(2);
        return n2;
    }

    public int getNumberOfOverlays() {
        int n = 0;
        for (int i = 0; i < 32; i += 2) {
            int n2 = (24576 + i << 16) + 16;
            DicomElement dicomElement = this.getDicomElement(new DicomTag(n2));
            try {
                if (dicomElement != null) {
                    ++n;
                    continue;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
            return n;
        }
        return n;
    }

    public ah getModalityLUTObject() {
        try {
            if (this.modalityLUTIsRescale()) {
                return new ah(this.getRescaleInterceptCorrect(), this.getRescaleSlopeCorrect());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        if (this.existsModalityLUTData()) {
            int n = this.getFirstMappedValueOfModalityLUT();
            if (this.isPixelRepresentationSigned()) {
                n = (short)n;
            }
            return new ah(this.getModalityLUTAsArray(), n);
        }
        return null;
    }

    private boolean modalityLUTIsRescale() {
        try {
            if (!this.existsDicomElement(BaseDicomTagNames.TAG_rescaleSlope)) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        try {
            if (!this.existsDicomElement(BaseDicomTagNames.TAG_rescaleIntercept)) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return true;
    }

    public double getRescaleSlopeCorrect() {
        aan aan2 = (aan)this.getDicomElement(BaseDicomTagNames.TAG_rescaleSlope);
        try {
            if (aan2 == null) {
                return 1.0;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            if (aan2.ac() == null) {
                return 1.0;
            }
            double d = Double.parseDouble(aan2.ac());
            if (d == 0.0) {
                return 1.0;
            }
            return d;
        }
        catch (Exception exception) {
            return 1.0;
        }
    }

    public double getRescaleInterceptCorrect() {
        aan aan2 = (aan)this.getDicomElement(BaseDicomTagNames.TAG_rescaleIntercept);
        try {
            if (aan2 == null) {
                return 0.0;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            if (aan2.ac() == null) {
                return 0.0;
            }
            return Double.parseDouble(aan2.ac());
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    private boolean existsModalityLUTData() {
        return this.existsDicomElement(BaseDicomTagNames.TAG_modalityLUTSequence);
    }

    private int getFirstMappedValueOfModalityLUT() {
        av av2 = (av)this.getDicomElement(BaseDicomTagNames.TAG_modalityLUTSequence);
        try {
            if (av2 == null) {
                return -1;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        int n = -1;
        try {
            DicomElementList dicomElementList = av2.aa(0);
            DicomElement dicomElement = dicomElementList.getDicomElement(BaseDicomTagNames.TAG_lutDescriptor);
            int n2 = dicomElement.getValueAsInt(0);
            n = dicomElement.getValueAsInt(1);
            int n3 = this.getPixelRepresentationAsInt();
            if (n3 == 1) {
                n = (short)n;
            } else if (n + n2 - 1 > 65535) {
                n = (short)n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private int[] getModalityLUTAsArray() {
        av av2 = (av)this.getDicomElement(BaseDicomTagNames.TAG_modalityLUTSequence);
        try {
            if (av2 == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        int[] nArray = null;
        try {
            DicomElementList dicomElementList = av2.aa(0);
            DicomElement dicomElement = dicomElementList.getDicomElement(BaseDicomTagNames.TAG_lutDescriptor);
            int n = dicomElement.getValueAsInt(0);
            DicomElement dicomElement2 = dicomElementList.getDicomElement(BaseDicomTagNames.TAG_lutData);
            nArray = new int[n];
            try {
                for (int i = 0; i < n; ++i) {
                    nArray[i] = dicomElement2.getValueAsInt(i) & 0xFFFF;
                }
            }
            catch (Exception exception) {
                throw ImageModule.a(exception);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nArray;
    }

    public boolean presentationLUTSequenceExists() {
        return this.existsDicomElement(BaseDicomTagNames.TAG_presentationLUTSequence);
    }

    public ai getPresentationLUTAsObject() {
        ai ai2;
        block3: {
            ai2 = new ai();
            ai2.ad = this.getPresentationLUTbitsUsed();
            ai2.ac = this.getFirstMappedValueOfPresentationLUT();
            ai2.aa = this.getNameOfPresentationLUT();
            ai2.ab = this.getPresentationLUTAsArray();
            int n = this.getPresentationLUTSize();
            try {
                if (n == ai2.ab.length || ai2.ad != 8) break block3;
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
            int[] nArray = new int[n];
            for (int i = 0; i < ai2.ab.length; ++i) {
                int n2 = ai2.ab[i] >> 8 & 0xFF;
                int n3 = ai2.ab[i] & 0xFF;
                nArray[2 * i] = n2;
                nArray[2 * i + 1] = n3;
            }
            ai2.ab = nArray;
        }
        return ai2;
    }

    private int getFirstMappedValueOfPresentationLUT() {
        av av2 = (av)this.getDicomElement(BaseDicomTagNames.TAG_presentationLUTSequence);
        try {
            if (av2 == null) {
                return -1;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            DicomElementList dicomElementList = av2.aa(0);
            DicomElement dicomElement = dicomElementList.getDicomElement(BaseDicomTagNames.TAG_lutDescriptor);
            int n = dicomElement.getValueAsInt(1);
            int n2 = this.getPixelRepresentationAsInt();
            if (n2 == 1) {
                n = (short)n;
            }
            return n;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private String getNameOfPresentationLUT() {
        av av2 = (av)this.getDicomElement(BaseDicomTagNames.TAG_presentationLUTSequence);
        try {
            if (av2 == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            DicomElementList dicomElementList = av2.aa(0);
            DicomElement dicomElement = dicomElementList.getDicomElement(BaseDicomTagNames.TAG_lutExplanation);
            String string = dicomElement.getValueAsString(0);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int[] getPresentationLUTAsArray() {
        av av2 = (av)this.getDicomElement(BaseDicomTagNames.TAG_presentationLUTSequence);
        try {
            if (av2 == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            DicomElementList dicomElementList = av2.aa(0);
            DicomElement dicomElement = dicomElementList.getDicomElement(BaseDicomTagNames.TAG_lutData);
            int n = dicomElement.getValueMultiplication();
            int[] nArray = new int[n];
            try {
                for (int i = 0; i < n; ++i) {
                    nArray[i] = dicomElement.getValueAsInt(i) & 0xFFFF;
                }
            }
            catch (Exception exception) {
                throw ImageModule.a(exception);
            }
            return nArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int getPresentationLUTSize() {
        av av2 = (av)this.getDicomElement(BaseDicomTagNames.TAG_presentationLUTSequence);
        try {
            if (av2 == null) {
                return 0;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            DicomElementList dicomElementList = av2.aa(0);
            DicomElement dicomElement = dicomElementList.getDicomElement(BaseDicomTagNames.TAG_lutDescriptor);
            int n = dicomElement.getValueAsInt(0);
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private int getPresentationLUTbitsUsed() {
        av av2 = (av)this.getDicomElement(BaseDicomTagNames.TAG_presentationLUTSequence);
        try {
            if (av2 == null) {
                return -1;
            }
        }
        catch (Exception exception) {
            throw ImageModule.a(exception);
        }
        try {
            DicomElementList dicomElementList = av2.aa(0);
            DicomElement dicomElement = dicomElementList.getDicomElement(BaseDicomTagNames.TAG_lutDescriptor);
            int n = dicomElement.getValueAsInt(2);
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean presentationLUTShapeExists() {
        try {
            if (this.getDicomElement(BaseDicomTagNames.TAG_presentationLUTShape) == null) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return true;
    }

    public String getPresentationLUTShape() {
        try {
            aam aam2 = (aam)this.getDicomElement(BaseDicomTagNames.TAG_presentationLUTShape);
            if (aam2 == null) {
                return null;
            }
            return aam2.ac();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void removePixelAspectRatio() {
        this.removeDicomElement(BaseDicomTagNames.TAG_pixelAspectRatio);
    }

    public void removeSmallestPixelValue() {
        this.removeDicomElement(BaseDicomTagNames.TAG_smallestImagePixelValue);
    }

    public void removeLargestPixelValue() {
        this.removeDicomElement(BaseDicomTagNames.TAG_largestImagePixelValue);
    }

    public void removeAllPalettes() {
        this.removeDicomElement(BaseDicomTagNames.TAG_redPaletteColorLookupTableDescriptor);
        this.removeDicomElement(BaseDicomTagNames.TAG_greenPaletteColorLookupTableDescriptor);
        this.removeDicomElement(BaseDicomTagNames.TAG_bluePaletteColorLookupTableDescriptor);
        this.removeDicomElement(BaseDicomTagNames.TAG_redPaletteColorLookupTableData);
        this.removeDicomElement(BaseDicomTagNames.TAG_greenPaletteColorLookupTableData);
        this.removeDicomElement(BaseDicomTagNames.TAG_bluePaletteColorLookupTableData);
        this.removeDicomElement(BaseDicomTagNames.TAG_paletteColorLookupTableUID);
    }

    public boolean isVisusInstance() {
        String string = this.getString(BaseDicomTagNames.TAG_sopInstanceUID);
        return aaf.ac(string);
    }

    public boolean hasVisusMPEGData() {
        boolean bl;
        block8: {
            block6: {
                try {
                    block7: {
                        try {
                            try {
                                if (!this.isVisusInstance()) break block6;
                                if (this.hasVisusMPEGData_old()) break block7;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw ImageModule.a(numberFormatException);
                            }
                            if (!this.hasVisusMPEGData_new()) break block6;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw ImageModule.a(numberFormatException);
                        }
                    }
                    bl = true;
                    break block8;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
            }
            bl = false;
        }
        return bl;
    }

    private boolean hasVisusMPEGData_old() {
        boolean bl;
        block5: {
            block4: {
                try {
                    try {
                        if (this.getDicomElement(DicomTagNames.TAG_visusMpegData_old) == null || this.getDicomElement(DicomTagNames.TAG_visusMpegDescription) == null) break block4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw ImageModule.a(numberFormatException);
                    }
                    bl = true;
                    break block5;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
            }
            bl = false;
        }
        return bl;
    }

    private boolean hasVisusMPEGData_new() {
        boolean bl;
        block5: {
            block4: {
                try {
                    try {
                        if (this.getDicomElement(DicomTagNames.TAG_visusMpegData_new) == null || this.getDicomElement(DicomTagNames.TAG_visusMpegDescription) == null) break block4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw ImageModule.a(numberFormatException);
                    }
                    bl = true;
                    break block5;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
            }
            bl = false;
        }
        return bl;
    }

    private ar getVisusMPEGData() {
        try {
            if (this.hasVisusMPEGData_old()) {
                return (ar)this.getDicomElement(DicomTagNames.TAG_visusMpegData_old);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        try {
            if (this.hasVisusMPEGData_new()) {
                return (ar)this.getDicomElement(DicomTagNames.TAG_visusMpegData_new);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return null;
    }

    public boolean isReducedMPEGObject() {
        block11: {
            block12: {
                String string = this.getString(DicomTagNames.TAG_visusDCMREDOriginalTS);
                try {
                    try {
                        if (string == null) break block11;
                        if (!TransferSyntaxValues.isMPEGTransferSyntax(string)) break block12;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw ImageModule.a(numberFormatException);
                    }
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
            }
            if (this.hasVisusMPEGData()) {
                ar ar2 = this.getVisusMPEGData();
                try {
                    block13: {
                        try {
                            try {
                                if (ar2 == null) break block11;
                                if (ar2.ab() == null) break block13;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw ImageModule.a(numberFormatException);
                            }
                            if (ar2.ab().length != 0) break block11;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw ImageModule.a(numberFormatException);
                        }
                    }
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
            }
        }
        return false;
    }

    public boolean reduceVisusMPEGData() {
        ar ar2 = this.getVisusMPEGData();
        try {
            if (ar2 != null) {
                ar2.aa(new byte[0]);
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return false;
    }

    public boolean hasVisusMpegIcon() {
        DicomModule dicomModule = this.getDicomModuleFromSequence(BaseDicomTagNames.TAG_iconImageSequence);
        try {
            if (dicomModule == null) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        try {
            if (!aaf.ac(this.getString(BaseDicomTagNames.TAG_sopInstanceUID))) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return true;
    }

    public boolean hasValidIconImageSequence() throws InvalidDataException {
        block49: {
            block46: {
                DicomModule dicomModule;
                block48: {
                    block47: {
                        dicomModule = this.getDicomModuleFromSequence(BaseDicomTagNames.TAG_iconImageSequence);
                        try {
                            try {
                                if (dicomModule == null) break block46;
                                if (dicomModule.existsDicomElement(BaseDicomTagNames.TAG_samplesPerPixel)) break block47;
                            }
                            catch (InvalidDataException invalidDataException) {
                                throw ImageModule.a(invalidDataException);
                            }
                            return false;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw ImageModule.a(invalidDataException);
                        }
                    }
                    try {
                        if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_photometricInterpretation)) {
                            return false;
                        }
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw ImageModule.a(invalidDataException);
                    }
                    try {
                        try {
                            if (dicomModule.getInt(DicomTagNames.TAG_samplesPerPixel) <= 1 || dicomModule.existsDicomElement(DicomTagNames.TAG_planarConfiguration)) break block48;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw ImageModule.a(invalidDataException);
                        }
                        return false;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw ImageModule.a(invalidDataException);
                    }
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_rows)) {
                        return false;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
                try {
                    if (this.getImageWidth() != dicomModule.getInt(BaseDicomTagNames.TAG_rows)) {
                        return false;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_columns)) {
                        return false;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
                try {
                    if (this.getImageHeight() != dicomModule.getInt(BaseDicomTagNames.TAG_columns)) {
                        return false;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_bitsStored)) {
                        return false;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_bitsAllocated)) {
                        return false;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_bitsStored)) {
                        return false;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_highBit)) {
                        return false;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_pixelRepresentation)) {
                        return false;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_pixelData)) {
                        return false;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
                DicomElement dicomElement = dicomModule.getDicomElement(BaseDicomTagNames.TAG_pixelData);
                if (dicomElement instanceof av) {
                    av av2 = (av)dicomElement;
                    try {
                        try {
                            if (av2.getValueMultiplication() >= 1 && av2.ab(1).ac()) break block49;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw ImageModule.a(invalidDataException);
                        }
                        return false;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw ImageModule.a(invalidDataException);
                    }
                }
                break block49;
            }
            return false;
        }
        return true;
    }

    public void setIconImageSeqenceToPixelData() throws CommonDicomException {
        block49: {
            DicomElement dicomElement;
            boolean bl;
            DicomModule dicomModule;
            block52: {
                block51: {
                    block50: {
                        dicomModule = this.getDicomModuleFromSequence(BaseDicomTagNames.TAG_iconImageSequence);
                        try {
                            try {
                                if (dicomModule == null) break block49;
                                if (dicomModule.existsDicomElement(BaseDicomTagNames.TAG_samplesPerPixel)) break block50;
                            }
                            catch (CommonDicomException commonDicomException) {
                                throw ImageModule.a(commonDicomException);
                            }
                            throw new CommonDicomException("Missing tag " + BaseDicomTagNames.TAG_samplesPerPixel + " in IconImageSequence");
                        }
                        catch (CommonDicomException commonDicomException) {
                            throw ImageModule.a(commonDicomException);
                        }
                    }
                    try {
                        if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_photometricInterpretation)) {
                            throw new CommonDicomException("Missing tag " + BaseDicomTagNames.TAG_photometricInterpretation + " in IconImageSequence");
                        }
                    }
                    catch (CommonDicomException commonDicomException) {
                        throw ImageModule.a(commonDicomException);
                    }
                    try {
                        try {
                            if (dicomModule.getInt(DicomTagNames.TAG_samplesPerPixel) <= 1 || dicomModule.existsDicomElement(DicomTagNames.TAG_planarConfiguration)) break block51;
                        }
                        catch (CommonDicomException commonDicomException) {
                            throw ImageModule.a(commonDicomException);
                        }
                        throw new CommonDicomException("Missing tag " + DicomTagNames.TAG_planarConfiguration + " in IconImageSequence");
                    }
                    catch (CommonDicomException commonDicomException) {
                        throw ImageModule.a(commonDicomException);
                    }
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_rows)) {
                        throw new CommonDicomException("Missing tag " + BaseDicomTagNames.TAG_rows + " in IconImageSequence");
                    }
                }
                catch (CommonDicomException commonDicomException) {
                    throw ImageModule.a(commonDicomException);
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_columns)) {
                        throw new CommonDicomException("Missing tag " + BaseDicomTagNames.TAG_columns + " in IconImageSequence");
                    }
                }
                catch (CommonDicomException commonDicomException) {
                    throw ImageModule.a(commonDicomException);
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_bitsStored)) {
                        throw new CommonDicomException("Missing tag " + BaseDicomTagNames.TAG_bitsStored + " in IconImageSequence");
                    }
                }
                catch (CommonDicomException commonDicomException) {
                    throw ImageModule.a(commonDicomException);
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_bitsAllocated)) {
                        throw new CommonDicomException("Missing tag " + BaseDicomTagNames.TAG_bitsAllocated + " in IconImageSequence");
                    }
                }
                catch (CommonDicomException commonDicomException) {
                    throw ImageModule.a(commonDicomException);
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_bitsStored)) {
                        throw new CommonDicomException("Missing tag " + BaseDicomTagNames.TAG_bitsStored + " in IconImageSequence");
                    }
                }
                catch (CommonDicomException commonDicomException) {
                    throw ImageModule.a(commonDicomException);
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_highBit)) {
                        throw new CommonDicomException("Missing tag " + BaseDicomTagNames.TAG_highBit + " in IconImageSequence");
                    }
                }
                catch (CommonDicomException commonDicomException) {
                    throw ImageModule.a(commonDicomException);
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_pixelRepresentation)) {
                        throw new CommonDicomException("Missing tag " + BaseDicomTagNames.TAG_pixelRepresentation + " in IconImageSequence");
                    }
                }
                catch (CommonDicomException commonDicomException) {
                    throw ImageModule.a(commonDicomException);
                }
                try {
                    if (!dicomModule.existsDicomElement(BaseDicomTagNames.TAG_pixelData)) {
                        throw new CommonDicomException("Missing tag " + BaseDicomTagNames.TAG_pixelData + " in IconImageSequence");
                    }
                }
                catch (CommonDicomException commonDicomException) {
                    throw ImageModule.a(commonDicomException);
                }
                ImageModule imageModule = new ImageModule(dicomModule);
                bl = imageModule.isColorPalette();
                dicomElement = (DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_pixelData).clone();
                if (dicomElement instanceof av) {
                    av av2 = (av)dicomElement;
                    try {
                        try {
                            if (av2.getValueMultiplication() >= 1 && av2.ab(1).ac()) break block52;
                        }
                        catch (CommonDicomException commonDicomException) {
                            throw ImageModule.a(commonDicomException);
                        }
                        throw new CommonDicomException("Invalid PixelData tag " + BaseDicomTagNames.TAG_pixelData + " in IconImageSequence");
                    }
                    catch (CommonDicomException commonDicomException) {
                        throw ImageModule.a(commonDicomException);
                    }
                }
            }
            try {
                this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_samplesPerPixel).clone());
                this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_photometricInterpretation).clone());
                if (dicomModule.existsDicomElement(DicomTagNames.TAG_planarConfiguration)) {
                    this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_planarConfiguration).clone());
                }
            }
            catch (CommonDicomException commonDicomException) {
                throw ImageModule.a(commonDicomException);
            }
            try {
                this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_rows).clone());
                this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_columns).clone());
                if (dicomModule.existsDicomElement(BaseDicomTagNames.TAG_pixelAspectRatio)) {
                    this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_pixelAspectRatio).clone());
                }
            }
            catch (CommonDicomException commonDicomException) {
                throw ImageModule.a(commonDicomException);
            }
            try {
                this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_bitsAllocated).clone());
                this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_bitsStored).clone());
                this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_highBit).clone());
                this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_pixelRepresentation).clone());
                if (bl) {
                    this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_redPaletteColorLookupTableDescriptor).clone());
                    this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_redPaletteColorLookupTableData).clone());
                    this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_bluePaletteColorLookupTableDescriptor).clone());
                    this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_bluePaletteColorLookupTableData).clone());
                    this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_greenPaletteColorLookupTableDescriptor).clone());
                    this.insertDicomElement((DicomElement)dicomModule.getDicomElement(BaseDicomTagNames.TAG_greenPaletteColorLookupTableData).clone());
                }
            }
            catch (CommonDicomException commonDicomException) {
                throw ImageModule.a(commonDicomException);
            }
            this.insertDicomElement(dicomElement);
        }
    }

    public ar getElementContainingVideoData(boolean bl) throws CommonDicomException {
        av av2;
        boolean bl2;
        DicomElement dicomElement = null;
        if (this.hasVisusMPEGData_old()) {
            dicomElement = this.getDicomElement(DicomTagNames.TAG_visusMpegData_old);
        } else if (this.hasVisusMPEGData_new()) {
            dicomElement = this.getDicomElement(DicomTagNames.TAG_visusMpegData_new);
        } else if (bl && (bl2 = (av2 = (av)this.getDicomElement(BaseDicomTagNames.TAG_pixelData)).ab(1).ac())) {
            dicomElement = av2.ab(1).ab().getDicomElementAt(0);
        }
        try {
            if (!(dicomElement instanceof ar)) {
                throw new CommonDicomException("Could not find video data!");
            }
        }
        catch (CommonDicomException commonDicomException) {
            throw ImageModule.a(commonDicomException);
        }
        return (ar)dicomElement;
    }

    public boolean hasVisusPreviewData() {
        block9: {
            boolean bl;
            DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_visusDICOMpre_previewFrame);
            try {
                if (dicomElement == null || dicomElement.getValueMultiplication() <= 0) break block9;
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
            byte[] byArray = dicomElement.getValueAsByteArray();
            if (byArray == null) {
                boolean bl2;
                block11: {
                    block10: {
                        short[] sArray = dicomElement.getValueAsShortArray();
                        try {
                            try {
                                if (sArray == null || sArray.length <= 0) break block10;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw ImageModule.a(numberFormatException);
                            }
                            bl2 = true;
                            break block11;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw ImageModule.a(numberFormatException);
                        }
                    }
                    bl2 = false;
                }
                return bl2;
            }
            try {
                bl = byArray.length > 0;
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
            return bl;
        }
        return false;
    }

    public byte[] getVisusPreviewDataAsByteArray() {
        DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_visusDICOMpre_previewFrame);
        try {
            if (dicomElement != null) {
                return ((ar)dicomElement).ab();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return null;
    }

    public short[] getVisusPreviewDataAsShortArray() {
        DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_visusDICOMpre_previewFrame);
        try {
            if (dicomElement != null) {
                return ((au)dicomElement).ab();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return null;
    }

    public void setVisusPreviewData(short[] sArray) {
        block3: {
            block2: {
                DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_visusDICOMpre_previewFrame);
                try {
                    if (!(dicomElement instanceof au)) break block2;
                    ((au)dicomElement).aa(sArray);
                    break block3;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
            }
            this.ensurePrivateGroupTag();
            this.removeDicomElement(DicomTagNames.TAG_visusDICOMpre_previewFrame);
            au au2 = new au(DicomTagNames.TAG_visusDICOMpre_previewFrame);
            au2.aa(sArray);
            this.insertDicomElement(au2);
        }
    }

    public void setVisusPreviewData(byte[] byArray) {
        block3: {
            block2: {
                DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_visusDICOMpre_previewFrame);
                try {
                    if (!(dicomElement instanceof ar)) break block2;
                    ((ar)dicomElement).aa(byArray);
                    break block3;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
            }
            this.ensurePrivateGroupTag();
            this.removeDicomElement(DicomTagNames.TAG_visusDICOMpre_previewFrame);
            ar ar2 = new ar(DicomTagNames.TAG_visusDICOMpre_previewFrame);
            ar2.aa(byArray);
            this.insertDicomElement(ar2);
        }
    }

    private void ensurePrivateGroupTag() {
        try {
            DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_visusPrivateCreatorDICOMpreTags);
            if (dicomElement == null) {
                aac aac2 = new aac(DicomTagNames.TAG_visusPrivateCreatorDICOMpreTags);
                aac2.ab("Visus Preview Data");
                this.insertDicomElement(aac2);
            }
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
    }

    public void copyPixelDataToVisusPreviewData() {
        block5: {
            block6: {
                DicomElement dicomElement;
                block4: {
                    dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_pixelData);
                    try {
                        if (!(dicomElement instanceof ar)) break block4;
                        this.setVisusPreviewData(dicomElement.getValueAsByteArray());
                        break block5;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw ImageModule.a(numberFormatException);
                    }
                }
                try {
                    if (!(dicomElement instanceof au)) break block6;
                    this.setVisusPreviewData(dicomElement.getValueAsShortArray());
                    break block5;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
            }
            this.setVisusPreviewData(this.convertPixelDataAsByteArray());
        }
    }

    public void copyVisusPreviewDataToPixelData() {
        block6: {
            DicomElement dicomElement;
            block5: {
                dicomElement = this.getDicomElement(DicomTagNames.TAG_visusDICOMpre_previewFrame);
                try {
                    if (!(dicomElement instanceof ar)) break block5;
                    this.setPixelDataBytes(dicomElement.getValueAsByteArray());
                    break block6;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
            }
            try {
                if (dicomElement instanceof au) {
                    this.setPixelDataWords(dicomElement.getValueAsShortArray());
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
        }
    }

    public void extractImageOverlays(short[] sArray, int n, short[] sArray2) {
        int n2 = sArray2.length;
        int n3 = aq.aa[n];
        for (int i = 0; i < n2; ++i) {
            short s = sArray2[i];
            int n4 = s & n3;
            try {
                if (n4 == 0) continue;
                sArray[i / 16] = (short)(sArray[i / 16] | aq.aa[i % 16]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
        }
    }

    public void extractImageOverlays(byte[] byArray, int n, byte[] byArray2) {
        int n2 = byArray2.length;
        int n3 = aq.aa[n];
        for (int i = 0; i < n2; ++i) {
            short s = byArray2[i];
            int n4 = s & n3;
            try {
                if (n4 == 0) continue;
                byArray[i / 8] = (byte)(byArray[i / 8] | aq.aa[i % 8]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
        }
    }

    private boolean isUSValue(DicomTag dicomTag) {
        return this.getDicomElement(dicomTag) instanceof al;
    }

    public void extractImageOverlays(Object object) throws InvalidDataException {
        for (int i = 0; i < 32; i += 2) {
            Object object2;
            al al2;
            block17: {
                com.visustt.dicomTk.data.aq aq2;
                int n;
                DicomTag dicomTag;
                block15: {
                    block16: {
                        DicomTag dicomTag2 = new DicomTag((24576 + i << 16) + 16);
                        DicomTag dicomTag3 = new DicomTag((24576 + i << 16) + 17);
                        dicomTag = new DicomTag((24576 + i << 16) + 12288);
                        DicomTag dicomTag4 = new DicomTag((24576 + i << 16) + 258);
                        DicomTag dicomTag5 = new DicomTag((24576 + i << 16) + 21);
                        try {
                            if (!this.existsDicomElement(dicomTag2) || this.existsDicomElement(dicomTag)) continue;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw ImageModule.a(invalidDataException);
                        }
                        DicomTag dicomTag6 = null;
                        if (!this.isUSValue(dicomTag3)) {
                            dicomTag6 = dicomTag3;
                        } else if (!this.isUSValue(dicomTag2)) {
                            dicomTag6 = dicomTag2;
                        } else if (!this.isUSValue(dicomTag4)) {
                            dicomTag6 = dicomTag4;
                        }
                        try {
                            if (dicomTag6 != null) {
                                logger.error("According to DICOM Part6, the VR of tag " + dicomTag6 + " must be US");
                                throw new InvalidDataException("Bad VR for tag " + dicomTag6);
                            }
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw ImageModule.a(invalidDataException);
                        }
                        al al3 = (al)this.getDicomElement(dicomTag3);
                        al al4 = (al)this.getDicomElement(dicomTag2);
                        al2 = (al)this.getDicomElement(dicomTag4);
                        n = al3.aa() * al4.aa();
                        if (this.existsDicomElement(dicomTag5)) {
                            object2 = (aao)this.getDicomElement(dicomTag5);
                            n *= ((DicomElement)object2).getValueAsInt(0);
                        }
                        try {
                            if (!(object instanceof short[])) break block15;
                            if (n > 1) break block16;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw ImageModule.a(invalidDataException);
                        }
                        n = ((short[])object).length;
                    }
                    n = n % 16 != 0 ? n / 16 + 1 : (n /= 16);
                    object2 = new short[n];
                    aq2 = new au(dicomTag);
                    ((au)aq2).aa((short[])object2);
                    this.extractImageOverlays((short[])object2, al2.getValueAsInt(0), (short[])object);
                    this.insertDicomElement(aq2);
                    break block17;
                }
                if (n <= 1) {
                    n = ((byte[])object).length;
                }
                n = n % 16 != 0 ? n / 16 + 1 : (n /= 16);
                n = n % 8 != 0 ? n / 8 + 1 : (n /= 8);
                object2 = new byte[n];
                aq2 = new ar(dicomTag);
                ((ar)aq2).aa((byte[])object2);
                this.extractImageOverlays((byte[])object2, al2.getValueAsInt(0), (byte[])object);
            }
            object2 = new al(new DicomTag((24576 + i << 16) + 256), 1);
            this.insertDicomElement((DicomElement)object2);
            al2.ac(0);
        }
    }

    /*
     * Loose catch block
     */
    public void insertExternalOverlaysInImage(aaa aaa2, Object object, int n) throws InvalidDataException {
        int n2;
        block16: {
            for (n2 = 1; n2 < aaa2.ac(); n2 <<= 1) {
            }
            try {
                if (!this.isMonochrome1() || !Boolean.parseBoolean(System.getProperty("jx.vb.display6000OverlaysWhite", "true"))) break block16;
            }
            catch (Exception exception) {
                throw ImageModule.a(exception);
            }
            n2 = aaa2.ab();
        }
        int n3 = 0;
        if (object instanceof short[]) {
            n3 = ((short[])object).length;
            n2 = (short)(n2 & 0xFFFF);
        } else if (object instanceof byte[]) {
            n3 = ((byte[])object).length;
            n2 = n2 > 255 ? 255 : (int)((byte)(n2 & 0xFF));
        } else {
            throw new InvalidDataException("Wrong data in insertExternalOverlaysInImage");
        }
        for (int i = 0; i < 32; i += 2) {
            DicomTag dicomTag = new DicomTag((24576 + i << 16) + 16);
            DicomTag dicomTag2 = new DicomTag((24576 + i << 16) + 17);
            DicomTag dicomTag3 = new DicomTag((24576 + i << 16) + 12288);
            if (!this.existsDicomElementWithAtLeastOneValue(dicomTag)) continue;
            try {
                block17: {
                    if (!this.existsDicomElementWithAtLeastOneValue(dicomTag2)) continue;
                    break block17;
                    catch (Exception exception) {
                        throw ImageModule.a(exception);
                    }
                }
                if (!this.existsDicomElementWithAtLeastOneValue(dicomTag3)) continue;
            }
            catch (Exception exception) {
                throw ImageModule.a(exception);
            }
            try {
                int n4 = this.getInt(dicomTag);
                int n5 = this.getInt(dicomTag2);
                int n6 = n4 * n5;
                if (n6 <= 1) {
                    n6 = n3;
                }
                DicomElement dicomElement = this.contents.getDicomElement(dicomTag3);
                DicomTag dicomTag4 = new DicomTag((24576 + i << 16) + 80);
                int n7 = this.getInt(dicomTag4, 0) - 1;
                int n8 = this.getInt(dicomTag4, 1) - 1;
                if (dicomElement.getElementLength() == 0) {
                    logger.warn("Image has (60xx,3000) \"OverayData\"-Tag without data! Expected was an content size of " + n6 + " bytes.");
                    return;
                }
                aq.aa(object, this.getRowsAsInt(), this.getColumnsAsInt(), dicomElement.getValuesAsObject(), n4, n5, n7, n8, n2, n);
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)("Found an invalid overlay-60xx-block. " + exception), exception);
            }
        }
    }

    public void insertExternalOverlaysInImageRGB(byte[] byArray, int n) throws InvalidDataException {
        int n2 = 0;
        n2 = byArray.length;
        for (int i = 0; i < 32; i += 2) {
            DicomTag dicomTag = new DicomTag((24576 + i << 16) + 16);
            DicomTag dicomTag2 = new DicomTag((24576 + i << 16) + 17);
            DicomTag dicomTag3 = new DicomTag((24576 + i << 16) + 12288);
            try {
                if (!this.existsDicomElementWithAtLeastOneValue(dicomTag) || !this.existsDicomElementWithAtLeastOneValue(dicomTag3)) continue;
            }
            catch (InvalidDataException invalidDataException) {
                throw ImageModule.a(invalidDataException);
            }
            int n3 = this.getInt(dicomTag);
            int n4 = this.getInt(dicomTag2);
            int n5 = n3 * n4;
            if (n5 <= 1) {
                n5 = n2;
            }
            DicomElement dicomElement = this.contents.getDicomElement(dicomTag3);
            DicomTag dicomTag4 = new DicomTag((24576 + i << 16) + 80);
            int n6 = this.getInt(dicomTag4, 0) - 1;
            int n7 = this.getInt(dicomTag4, 1) - 1;
            try {
                if (dicomElement.getElementLength() == 0) {
                    logger.warn("Image has (60xx,3000) \"OverayData\"-Tag without data! Expected was an content size of " + n5 + " bytes.");
                    return;
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw ImageModule.a(invalidDataException);
            }
            aq.aa(byArray, this.getRowsAsInt(), this.getColumnsAsInt(), dicomElement.getValuesAsObject(), n3, n4, n6, n7, n);
        }
    }

    public void extract6000OverlaysToOwnBlob(byte[] byArray, int n) {
        int n2 = 255;
        int n3 = byArray.length;
        for (int i = 0; i < 32; i += 2) {
            DicomTag dicomTag = new DicomTag((24576 + i << 16) + 16);
            DicomTag dicomTag2 = new DicomTag((24576 + i << 16) + 17);
            DicomTag dicomTag3 = new DicomTag((24576 + i << 16) + 12288);
            if (!this.bitmapOverlayElementsRowColDataExists(dicomTag, dicomTag2, dicomTag3)) continue;
            try {
                DicomTag dicomTag4;
                int n4;
                int n5 = this.getInt(dicomTag);
                int n6 = this.getInt(dicomTag2);
                int n7 = n5 * n6;
                if (n7 <= 1) {
                    n7 = n3;
                }
                if (n < (n4 = this.getBitmapOverlayFrameOrigin(dicomTag4 = new DicomTag((24576 + i << 16) + 81)))) continue;
                n -= n4;
                DicomElement dicomElement = this.contents.getDicomElement(dicomTag3);
                DicomTag dicomTag5 = new DicomTag((24576 + i << 16) + 80);
                int n8 = this.getInt(dicomTag5, 0) - 1;
                int n9 = this.getInt(dicomTag5, 1) - 1;
                if (dicomElement.getElementLength() == 0) {
                    logger.warn("Image has (60xx,3000) \"OverayData\"-Tag without data! Expected was an content size of " + n7 + " bytes.");
                    return;
                }
                aq.aa(byArray, this.getRowsAsInt(), this.getColumnsAsInt(), dicomElement.getValuesAsObject(), n5, n6, n8, n9, n2, n);
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)("Found an invalid overlay-60xx-block. " + exception), exception);
            }
        }
    }

    protected int getBitmapOverlayFrameOrigin(DicomTag dicomTag) throws InvalidDataException {
        int n = 0;
        if (this.contents.hasDicomElement(dicomTag)) {
            n = this.contents.getDicomElement(dicomTag).getValueAsInt(0) - 1;
        }
        return n;
    }

    protected boolean bitmapOverlayElementsRowColDataExists(DicomTag dicomTag, DicomTag dicomTag2, DicomTag dicomTag3) {
        boolean bl;
        block7: {
            block6: {
                try {
                    try {
                        try {
                            if (!this.existsDicomElementWithAtLeastOneValue(dicomTag) || !this.existsDicomElementWithAtLeastOneValue(dicomTag2)) break block6;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw ImageModule.a(numberFormatException);
                        }
                        if (!this.existsDicomElementWithAtLeastOneValue(dicomTag3)) break block6;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw ImageModule.a(numberFormatException);
                    }
                    bl = true;
                    break block7;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public static DicomObject createGrayImageObject(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, Object object) throws InvalidDataException {
        ImageModule imageModule;
        DicomObject dicomObject;
        block7: {
            block6: {
                block5: {
                    block4: {
                        dicomObject = new DicomObject();
                        imageModule = dicomObject.getImageModule();
                        try {
                            if (!bl) break block4;
                            imageModule.setPixelRepresentation(1);
                            break block5;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw ImageModule.a(invalidDataException);
                        }
                    }
                    imageModule.setPixelRepresentation(0);
                }
                try {
                    if (!bl2) break block6;
                    imageModule.setPhotometricInterpretation("MONOCHROME1");
                    break block7;
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
            }
            imageModule.setPhotometricInterpretation("MONOCHROME2");
        }
        dicomObject.getSeriesModule().setModality("OT");
        imageModule.setSamplesPerPixel(1);
        imageModule.setRows(n);
        imageModule.setColumns(n2);
        imageModule.setBitsAllocated(n3);
        imageModule.setBitsStored(n4);
        imageModule.setHighBit(n5);
        imageModule.setLargestPixelValue(n6);
        imageModule.setSmallestPixelValue(n7);
        imageModule.setPixelData(object);
        return dicomObject;
    }

    public boolean isLossyCompression() {
        String string = this.getString(BaseDicomTagNames.TAG_lossyImageCompression);
        try {
            if (string != null) {
                return string.equals("01");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return false;
    }

    public void handleBounds(aaa aaa2) throws InvalidDataException {
        block6: {
            try {
                try {
                    try {
                        if (ac.ak || aaa2.ab() != -1) break block6;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw ImageModule.a(invalidDataException);
                    }
                    if (aaa2.ac() != -1) break block6;
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
                return;
            }
            catch (InvalidDataException invalidDataException) {
                throw ImageModule.a(invalidDataException);
            }
        }
        this.contents.setParsedImageInformation(new az());
        this.contents.getParsedImageInformation().aa(aaa2);
        this.setLargestPixelValue(aaa2.ac());
        this.setSmallestPixelValue(aaa2.ab());
    }

    public void updateBounds(aaa aaa2) throws InvalidDataException {
        aaa aaa3 = this.contents.getParsedImageInformation().aa();
        try {
            if (aaa2.ab() < aaa3.ab()) {
                aaa3.aa(aaa2.ab());
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ImageModule.a(invalidDataException);
        }
        try {
            if (aaa2.ad() < aaa3.ad()) {
                aaa3.ac(aaa2.ad());
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ImageModule.a(invalidDataException);
        }
        try {
            if (aaa2.ac() > aaa3.ac()) {
                aaa3.ab(aaa2.ac());
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ImageModule.a(invalidDataException);
        }
        try {
            if (aaa2.ae() > aaa3.ae()) {
                aaa3.ad(aaa2.ae());
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ImageModule.a(invalidDataException);
        }
        this.contents.getParsedImageInformation().aa(aaa3);
        this.setLargestPixelValue(aaa3.ac());
        this.setSmallestPixelValue(aaa3.ab());
    }

    public static short[] getTestShort(int n, int n2, int n3, int n4) {
        short[] sArray = new short[n2 * n];
        double d = (double)(n3 - n4) / (double)(n2 - 1);
        double d2 = n4;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            try {
                for (int j = 0; j < n; ++j) {
                    sArray[n5] = (short)d2;
                    ++n5;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
            d2 += d;
        }
        return sArray;
    }

    public static byte[] getTestByte(int n, int n2, int n3, int n4) {
        byte[] byArray = new byte[n2 * n];
        double d = (double)(n3 - n4) / (double)(n2 - 1);
        double d2 = n4;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            try {
                for (int j = 0; j < n; ++j) {
                    byArray[n5] = (byte)d2;
                    ++n5;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
            d2 += d;
        }
        return byArray;
    }

    public static DicomObject createTestObjectShortImage(String string, String string2) throws CommonDicomException {
        return ImageModule.createTestObjectShortImage(string, string2, 128, 128);
    }

    public static DicomObject createTestObjectShortImage(String string, String string2, int n, int n2) throws CommonDicomException {
        int n3 = 15;
        int n4 = 16;
        int n5 = 16;
        int n6 = Short.MAX_VALUE;
        int n7 = Short.MIN_VALUE;
        short[] sArray = ImageModule.getTestShort(n2, n, Short.MAX_VALUE, Short.MIN_VALUE);
        DicomObject dicomObject = ImageModule.createGrayImageObject(n2, n, 16, 16, 15, Short.MAX_VALUE, Short.MIN_VALUE, true, false, sArray);
        dicomObject.getStudyModule().setStudyInstanceUID(string);
        dicomObject.getSeriesModule().setSeriesInstanceUID(string2);
        dicomObject.getSOPCommonModule().ab(aaf.aa(string2));
        dicomObject.getSOPCommonModule().aa("1.2.840.10008.5.1.4.1.1.7");
        return dicomObject;
    }

    public void setFrameToFirst(int n) throws CommonDicomException {
        block4: {
            try {
                try {
                    if (!this.isMultiframeImage() || !this.isEmbeddedPixelData()) break block4;
                }
                catch (CommonDicomException commonDicomException) {
                    throw ImageModule.a(commonDicomException);
                }
                if (this.getNumberOfFrames() <= n) break block4;
            }
            catch (CommonDicomException commonDicomException) {
                throw ImageModule.a(commonDicomException);
            }
            av av2 = (av)this.contents.getDicomElement(BaseDicomTagNames.TAG_pixelData);
            av2.aa(1, n + 1);
        }
    }

    public boolean isVoxarLiveImage() {
        block12: {
            String string = this.getString(BaseDicomTagNames.TAG_manufacturerModelName);
            String string2 = this.getString(BaseDicomTagNames.TAG_manufacturer);
            String string3 = this.getString(BaseDicomTagNames.TAG_seriesDescription);
            try {
                try {
                    try {
                        try {
                            try {
                                try {
                                    if (string == null || string2 == null) break block12;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw ImageModule.a(numberFormatException);
                                }
                                if (string3 == null) break block12;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw ImageModule.a(numberFormatException);
                            }
                            if (!string.equalsIgnoreCase("Voxar 3D")) break block12;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw ImageModule.a(numberFormatException);
                        }
                        if (!string2.equalsIgnoreCase("Barco")) break block12;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw ImageModule.a(numberFormatException);
                    }
                    if (!string3.equalsIgnoreCase("Live Image sculpting + selection state")) break block12;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ImageModule.a(numberFormatException);
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
        }
        return false;
    }

    public int getPixelDataLength() {
        Object[] objectArray;
        DicomElement dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_pixelData);
        if (dicomElement instanceof ar) {
            objectArray = ((ar)dicomElement).ab();
            try {
                if (objectArray != null) {
                    return objectArray.length;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
        }
        if (dicomElement instanceof au) {
            objectArray = ((au)dicomElement).ab();
            try {
                if (objectArray != null) {
                    return objectArray.length;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ImageModule.a(numberFormatException);
            }
        }
        return -1;
    }

    public boolean containsPixelData() throws NoValidDicomObjectException, UnsupportedTransferSyntaxException, UnsupportedDicomObjectException, CommonDicomException {
        block8: {
            boolean bl;
            try {
                bl = this.getDicomElement(BaseDicomTagNames.TAG_pixelData) != null;
            }
            catch (NoValidDicomObjectException noValidDicomObjectException) {
                throw ImageModule.a(noValidDicomObjectException);
            }
            boolean bl2 = bl;
            try {
                try {
                    try {
                        if (!bl2 || this.getRowsAsInt() <= 0) break block8;
                    }
                    catch (NoValidDicomObjectException noValidDicomObjectException) {
                        throw ImageModule.a(noValidDicomObjectException);
                    }
                    if (this.getColumnsAsInt() <= 0) break block8;
                }
                catch (NoValidDicomObjectException noValidDicomObjectException) {
                    throw ImageModule.a(noValidDicomObjectException);
                }
                return true;
            }
            catch (NoValidDicomObjectException noValidDicomObjectException) {
                throw ImageModule.a(noValidDicomObjectException);
            }
        }
        return false;
    }

    public boolean containsPixelDataOrVisusMpeg() throws NoValidDicomObjectException, UnsupportedTransferSyntaxException, UnsupportedDicomObjectException, CommonDicomException {
        boolean bl;
        block5: {
            block4: {
                try {
                    try {
                        if (!this.containsPixelData() && !this.hasVisusMPEGData()) break block4;
                    }
                    catch (NoValidDicomObjectException noValidDicomObjectException) {
                        throw ImageModule.a(noValidDicomObjectException);
                    }
                    bl = true;
                    break block5;
                }
                catch (NoValidDicomObjectException noValidDicomObjectException) {
                    throw ImageModule.a(noValidDicomObjectException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public boolean is1MPix1BitMultiframeSC() throws InvalidDataException {
        block8: {
            try {
                try {
                    try {
                        try {
                            if (!"1.2.840.10008.5.1.4.1.1.7.1".equals(this.getSOPClassUID()) || this.getBitsStoredAsInt() != 1) break block8;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw ImageModule.a(invalidDataException);
                        }
                        if (this.getBitsAllocatedAsInt() != 1) break block8;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw ImageModule.a(invalidDataException);
                    }
                    if (this.getColumnsAsInt() * this.getRowsAsInt() <= 1000000) break block8;
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageModule.a(invalidDataException);
                }
                return true;
            }
            catch (InvalidDataException invalidDataException) {
                throw ImageModule.a(invalidDataException);
            }
        }
        return false;
    }

    public boolean isImagerPixelSpacingUsedWithoutMagnificationFactor() {
        return this.imagerPixelSpacingUsedWithoutMagnificationFactor;
    }

    public void setImagerPixelSpacingUsedWithoutMagnificationFactor(boolean bl) {
        this.imagerPixelSpacingUsedWithoutMagnificationFactor = bl;
    }

    public double getDefaultFrameRate() {
        float f = this.getRecommendedDisplayFrameRateInFloat();
        try {
            if (f != 0.0f) {
                return f;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        int n = this.getRecommendedDisplayFrameRate();
        try {
            if (n != 0) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        int n2 = this.getCineRate();
        try {
            if (n2 != 0) {
                return n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        double d = this.getFrameTime();
        try {
            if (d != 0.0) {
                return 1000.0 / d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        double d2 = this.getMedianOfFrameTimeVector();
        try {
            if (d2 != 0.0) {
                return 1000.0 / d2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return 0.0;
    }

    public double getMedianOfFrameTimeVector() {
        block5: {
            DicomElement dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_frameTimeVector);
            try {
                if (!(dicomElement instanceof aan) || dicomElement.getValueMultiplication() <= 0) break block5;
            }
            catch (InvalidDataException invalidDataException) {
                throw ImageModule.a(invalidDataException);
            }
            aan aan2 = (aan)dicomElement;
            try {
                double[] dArray = aan2.af();
                Arrays.sort(dArray);
                return aj.aa(dArray);
            }
            catch (InvalidDataException invalidDataException) {
                return 0.0;
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public byte[] reduceOWPixelDataToByteArray() {
        DicomElement dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_pixelData);
        try {
            if (dicomElement == null) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        try {
            if (dicomElement instanceof ar) {
                return ((ar)dicomElement).ab();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        short[] sArray = ((au)dicomElement).ab();
        byte[] byArray = new byte[sArray.length];
        try {
            for (int i = 0; i < sArray.length; ++i) {
                byArray[i] = (byte)(sArray[i] >> 8 & 0xFF);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ImageModule.a(numberFormatException);
        }
        return byArray;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

