/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk;

import com.visustt.dicomTk.ArrayCreationException;
import com.visustt.dicomTk.BaseDicomTagNames;
import com.visustt.dicomTk.CommonDicomException;
import com.visustt.dicomTk.DicomElementList;
import com.visustt.dicomTk.DicomModule;
import com.visustt.dicomTk.DicomTag;
import com.visustt.dicomTk.DicomTagNames;
import com.visustt.dicomTk.ImageModule;
import com.visustt.dicomTk.InvalidDataException;
import com.visustt.dicomTk.NoValidDicomObjectException;
import com.visustt.dicomTk.NoValidValueIndexException;
import com.visustt.dicomTk.PatientModule;
import com.visustt.dicomTk.SeriesModule;
import com.visustt.dicomTk.StudyModule;
import com.visustt.dicomTk.UnsupportedDicomObjectException;
import com.visustt.dicomTk.UnsupportedTransferSyntaxException;
import com.visustt.dicomTk.aa.af;
import com.visustt.dicomTk.aa.ag;
import com.visustt.dicomTk.ak.ad;
import com.visustt.dicomTk.ap;
import com.visustt.dicomTk.ar;
import com.visustt.dicomTk.aw;
import com.visustt.dicomTk.data.DicomElement;
import com.visustt.dicomTk.data.aam;
import com.visustt.dicomTk.data.av;
import com.visustt.dicomTk.data.ax;
import com.visustt.dicomTk.dict.DicomDictionary;
import com.visustt.dicomTk.imageplane.aa;
import com.visustt.dicomTk.util.aae;
import com.visustt.dicomTk.util.ai;
import com.visustt.dicomTk.util.aj;
import com.visustt.dicomTk.util.ak;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.io.FileAccess;
import com.visustt.tools.io.StoreUtil;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.util.ab.ab;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Vector;

public class DicomObject
extends DicomModule
implements Cloneable {
    private static Logger logger = LoggerFactory.getInstance("jx.dicomTk");
    protected ap fileMetaHeader = null;
    protected PatientModule ptMod = null;
    protected aa ipMod = null;
    protected SeriesModule seMod = null;
    protected StudyModule stMod = null;
    protected ad ptStMod = null;
    private com.visustt.dicomTk.ab.ar parsedTransferSyntax;
    private aw sopCommonModule;
    private ar equipmentModule = null;
    private long originalObjectSize = -1L;
    private long lastParsedTagPosition = -1L;

    public DicomObject() {
    }

    public DicomObject(DicomModule dicomModule) {
        super(dicomModule.getDicomElementList());
    }

    public DicomObject(DicomObject dicomObject) {
        super(dicomObject.getDicomElementList());
    }

    public DicomObject(DicomElementList dicomElementList) {
        super(dicomElementList);
    }

    public DicomObject(byte[] byArray) throws NoValidDicomObjectException, UnsupportedTransferSyntaxException, UnsupportedDicomObjectException, CommonDicomException {
        this(byArray, null, new com.visustt.dicomTk.ax());
    }

    public DicomObject(byte[] byArray, int n) throws NoValidDicomObjectException, UnsupportedDicomObjectException, CommonDicomException {
        com.visustt.dicomTk.ax ax2 = new com.visustt.dicomTk.ax();
        ax2.aa(true);
        this.handleStreamFailed(byArray, ax2, null, n);
        byArray = null;
    }

    public DicomObject(byte[] byArray, DicomTag dicomTag) throws NoValidDicomObjectException, UnsupportedDicomObjectException, CommonDicomException {
        this(byArray, dicomTag, true);
    }

    public DicomObject(byte[] byArray, DicomTag dicomTag, boolean bl) throws NoValidDicomObjectException, UnsupportedDicomObjectException, CommonDicomException {
        com.visustt.dicomTk.ax ax2 = new com.visustt.dicomTk.ax();
        ax2.aa(true);
        this.handleStream(byArray, ax2, null, dicomTag, bl);
    }

    public DicomObject(File file, DicomTag dicomTag) throws FileNotFoundException, IOException, NoValidDicomObjectException, UnsupportedDicomObjectException, CommonDicomException {
        this(file, dicomTag, false);
    }

    public DicomObject(File file, DicomTag dicomTag, boolean bl) throws FileNotFoundException, IOException, NoValidDicomObjectException, UnsupportedDicomObjectException, CommonDicomException {
        com.visustt.dicomTk.ax ax2 = new com.visustt.dicomTk.ax();
        ax2.aa(true);
        this.handleStream(FileAccess.getFileLocal(file), ax2, null, dicomTag, bl);
    }

    public DicomObject(byte[] byArray, String string) throws NoValidDicomObjectException, UnsupportedTransferSyntaxException, UnsupportedDicomObjectException, CommonDicomException {
        this(byArray, string, new com.visustt.dicomTk.ax());
    }

    public DicomObject(String string, String string2, com.visustt.dicomTk.ax ax2) throws FileNotFoundException, IOException, NoValidDicomObjectException, UnsupportedTransferSyntaxException, UnsupportedDicomObjectException, CommonDicomException {
        if (string2 != null) {
            try {
                if (!com.visustt.dicomTk.ab.ar.ab(string2)) {
                    throw new UnsupportedTransferSyntaxException();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw DicomObject.a(fileNotFoundException);
            }
        }
        this.handleStream(FileAccess.getFileLocal(new File(string)), ax2, string2);
    }

    public DicomObject(String string, String string2) throws FileNotFoundException, IOException, NoValidDicomObjectException, UnsupportedTransferSyntaxException, UnsupportedDicomObjectException, CommonDicomException {
        this(string, string2, new com.visustt.dicomTk.ax());
    }

    public DicomObject(String string) throws FileNotFoundException, IOException, NoValidDicomObjectException, UnsupportedTransferSyntaxException, UnsupportedDicomObjectException, CommonDicomException {
        this(string, null, new com.visustt.dicomTk.ax());
    }

    public DicomObject(byte[] byArray, String string, com.visustt.dicomTk.ax ax2) throws NoValidDicomObjectException, UnsupportedTransferSyntaxException, UnsupportedDicomObjectException, CommonDicomException {
        if (string != null) {
            try {
                if (!com.visustt.dicomTk.ab.ar.ab(string)) {
                    throw new UnsupportedTransferSyntaxException();
                }
            }
            catch (NoValidDicomObjectException noValidDicomObjectException) {
                throw DicomObject.a(noValidDicomObjectException);
            }
        }
        this.handleStream(byArray, ax2, string);
        byArray = null;
    }

    public DicomObject(InputStream inputStream, long l, com.visustt.dicomTk.ax ax2, DicomTag dicomTag, boolean bl) throws CommonDicomException {
        this.handleStream(inputStream, l, ax2, dicomTag, bl);
    }

    public static void preInit() {
        DicomDictionary.instance();
    }

    public void storeAsFile(String string) throws IOException, CommonDicomException {
        byte[] byArray = this.storeAsArray();
        StoreUtil.aa(byArray, new File(string));
    }

    public void storeAsFile(String string, String string2) throws IOException, CommonDicomException {
        try {
            if (!com.visustt.dicomTk.ab.ar.ab(string2)) {
                throw new UnsupportedTransferSyntaxException();
            }
        }
        catch (IOException iOException) {
            throw DicomObject.a(iOException);
        }
        byte[] byArray = this.storeAsArray(string2);
        StoreUtil.aa(byArray, new File(string));
    }

    public boolean isJPEGTransfer() {
        block4: {
            try {
                try {
                    if (!this.isEmbeddedPixelDecoder() || !(this.getParsedTransferSyntax().ah() instanceof com.visustt.dicomTk.ab.ad)) break block4;
                }
                catch (NullPointerException nullPointerException) {
                    throw DicomObject.a(nullPointerException);
                }
                return true;
            }
            catch (NullPointerException nullPointerException) {
                throw DicomObject.a(nullPointerException);
            }
        }
        return false;
    }

    public boolean isEmbeddedPixelDecoder() {
        boolean bl;
        block5: {
            block4: {
                try {
                    try {
                        if (this.parsedTransferSyntax == null || this.parsedTransferSyntax.ah() == null) break block4;
                    }
                    catch (NullPointerException nullPointerException) {
                        throw DicomObject.a(nullPointerException);
                    }
                    bl = true;
                    break block5;
                }
                catch (NullPointerException nullPointerException) {
                    throw DicomObject.a(nullPointerException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public byte[] storeAsArray() throws CommonDicomException {
        return this.storeAsArray(true);
    }

    public byte[] storeAsArray(boolean bl) throws CommonDicomException {
        try {
            block4: {
                try {
                    if (this.fileMetaHeader == null || this.fileMetaHeader.ah() == null) break block4;
                }
                catch (Exception exception) {
                    throw DicomObject.a(exception);
                }
                return this.storeAsArray(this.fileMetaHeader.ah(), bl);
            }
            return this.storeAsArray("1.2.840.10008.1.2", bl);
        }
        catch (Exception exception) {
            throw new ArrayCreationException("Cannot create byte stream:" + exception, exception);
        }
    }

    public byte[] storeAsArray(String string) throws UnsupportedTransferSyntaxException, CommonDicomException {
        return this.storeAsArray(string, true);
    }

    public byte[] storeAsArray(String string, boolean bl) throws UnsupportedTransferSyntaxException, CommonDicomException {
        Object object;
        com.visustt.dicomTk.ab.ar ar2;
        block9: {
            ar2 = com.visustt.dicomTk.ab.ar.aa(string);
            int n = 0;
            if (this.fileMetaHeader != null) {
                this.fileMetaHeader.ac(string);
                this.fileMetaHeader.ab();
                n = this.fileMetaHeader.ac();
            }
            try {
                if (ab.aa() || !bl) break block9;
            }
            catch (UnsupportedTransferSyntaxException unsupportedTransferSyntaxException) {
                throw DicomObject.a(unsupportedTransferSyntaxException);
            }
            object = this.getSpecificCharacterSetValue();
            try {
                if (object == null) {
                    this.setSpecificCharacterSetValue();
                }
            }
            catch (UnsupportedTransferSyntaxException unsupportedTransferSyntaxException) {
                throw DicomObject.a(unsupportedTransferSyntaxException);
            }
        }
        object = new byte[n += this.getByteArraySizeForAllElements(ar2)];
        ak ak2 = new ak((byte[])object);
        try {
            if (this.fileMetaHeader != null) {
                this.fileMetaHeader.aa(ak2);
            }
        }
        catch (UnsupportedTransferSyntaxException unsupportedTransferSyntaxException) {
            throw DicomObject.a(unsupportedTransferSyntaxException);
        }
        ar2.aa(this.getDicomElementList(), ak2);
        return ak2.ab();
    }

    public int getByteArraySizeForAllElementsIncludingFileMetaHeader(String string) throws UnsupportedTransferSyntaxException, CommonDicomException {
        com.visustt.dicomTk.ab.ar ar2 = com.visustt.dicomTk.ab.ar.aa(string);
        int n = 0;
        if (this.fileMetaHeader != null) {
            this.fileMetaHeader.ac(string);
            this.fileMetaHeader.ab();
            n = this.fileMetaHeader.ac();
        }
        return n + this.getByteArraySizeForAllElements(ar2);
    }

    public PatientModule getPatientModule() {
        try {
            if (this.ptMod == null) {
                this.ptMod = new PatientModule(this.getDicomElementList());
            }
        }
        catch (NullPointerException nullPointerException) {
            throw DicomObject.a(nullPointerException);
        }
        return this.ptMod;
    }

    public ad getPatientStudyModule() {
        try {
            if (this.ptStMod == null) {
                this.ptStMod = new ad(this.getDicomElementList());
            }
        }
        catch (NullPointerException nullPointerException) {
            throw DicomObject.a(nullPointerException);
        }
        return this.ptStMod;
    }

    public aa getImagePlaneModule() {
        try {
            if (this.ipMod == null) {
                this.ipMod = new aa(this.getDicomElementList());
            }
        }
        catch (NullPointerException nullPointerException) {
            throw DicomObject.a(nullPointerException);
        }
        return this.ipMod;
    }

    public boolean hasFileMetaHeader() {
        try {
            if (this.fileMetaHeader == null) {
                return false;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw DicomObject.a(nullPointerException);
        }
        return true;
    }

    public void removeFileMetaHeader() {
        this.fileMetaHeader = null;
    }

    public void createFileMetaHeader(String string, String string2, String string3) throws CommonDicomException {
        this.fileMetaHeader = new ap(string, string2, string3);
    }

    public void createFileMetaHeader(String string) throws CommonDicomException {
        try {
            this.getSOPCommonModule();
            if (!this.sopCommonModule.ah()) {
                throw new CommonDicomException("Missing SOP Instance UID or  SOP Class UID");
            }
        }
        catch (CommonDicomException commonDicomException) {
            throw DicomObject.a(commonDicomException);
        }
        this.fileMetaHeader = new ap(this.sopCommonModule.ab(), this.sopCommonModule.aa(), string);
    }

    public ap getFileMetaHeader() {
        return this.fileMetaHeader;
    }

    public StudyModule getStudyModule() {
        try {
            if (this.stMod == null) {
                this.stMod = new StudyModule(this.getDicomElementList());
            }
        }
        catch (NullPointerException nullPointerException) {
            throw DicomObject.a(nullPointerException);
        }
        return this.stMod;
    }

    public SeriesModule getSeriesModule() {
        try {
            if (this.seMod == null) {
                this.seMod = new SeriesModule(this.getDicomElementList());
            }
        }
        catch (NullPointerException nullPointerException) {
            throw DicomObject.a(nullPointerException);
        }
        return this.seMod;
    }

    public ImageModule getImageModule() {
        return this.getDicomElementList().getImageModule();
    }

    public ar getEquipmentModule() {
        try {
            if (this.equipmentModule == null) {
                this.equipmentModule = new ar(this.getDicomElementList());
            }
        }
        catch (NullPointerException nullPointerException) {
            throw DicomObject.a(nullPointerException);
        }
        return this.equipmentModule;
    }

    protected void handleStream(byte[] byArray, com.visustt.dicomTk.ax ax2, String string) throws NoValidDicomObjectException, UnsupportedTransferSyntaxException, UnsupportedDicomObjectException, CommonDicomException {
        this.handleStream(byArray, ax2, string, null);
    }

    protected void handleStream(byte[] byArray, com.visustt.dicomTk.ax ax2, String string, DicomTag dicomTag) throws NoValidDicomObjectException, UnsupportedTransferSyntaxException, UnsupportedDicomObjectException, CommonDicomException {
        this.handleStream(byArray, ax2, string, dicomTag, false);
    }

    protected void handleStream(byte[] byArray, com.visustt.dicomTk.ax ax2, String string, DicomTag dicomTag, boolean bl) throws NoValidDicomObjectException, UnsupportedTransferSyntaxException, UnsupportedDicomObjectException, CommonDicomException {
        ai ai2;
        block17: {
            block16: {
                block15: {
                    this.originalObjectSize = byArray.length;
                    String string2 = null;
                    if (ax2 != null) {
                        string2 = ax2.aa();
                    }
                    if ((ai2 = new ai(byArray, string2)).af()) {
                        try {
                            this.fileMetaHeader = new ap();
                            this.fileMetaHeader.aa(ai2);
                            string = this.fileMetaHeader.ah();
                        }
                        catch (NullPointerException nullPointerException) {
                            throw new NoValidDicomObjectException("Can't decode data.", nullPointerException);
                        }
                    }
                    try {
                        this.parsedTransferSyntax = string == null ? aae.aa(ai2) : com.visustt.dicomTk.ab.ar.aa(string);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw DicomObject.a(nullPointerException);
                    }
                    try {
                        if (this.parsedTransferSyntax == null) {
                            throw new UnsupportedTransferSyntaxException(string);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        throw DicomObject.a(nullPointerException);
                    }
                    try {
                        try {
                            if (ax2 == null || !ax2.af()) break block15;
                        }
                        catch (NullPointerException nullPointerException) {
                            throw DicomObject.a(nullPointerException);
                        }
                        return;
                    }
                    catch (NullPointerException nullPointerException) {
                        throw DicomObject.a(nullPointerException);
                    }
                }
                try {
                    if (dicomTag != null) break block16;
                    this.parsedTransferSyntax.aa(ai2, this.contents, ax2);
                    break block17;
                }
                catch (NullPointerException nullPointerException) {
                    throw DicomObject.a(nullPointerException);
                }
            }
            this.parsedTransferSyntax.aa(ai2, this.contents, ax2, dicomTag, bl, -1);
        }
        ai2.ae();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleStream(InputStream inputStream, long l, com.visustt.dicomTk.ax ax2, DicomTag dicomTag, boolean bl) throws CommonDicomException {
        aj aj2;
        block22: {
            block21: {
                block20: {
                    String string;
                    block19: {
                        block18: {
                            if (l < 0L) throw new UnsupportedDicomObjectException("The original object size [" + this.originalObjectSize + "] is beyond the limits of JiveX.");
                            try {
                                if (l <= Integer.MAX_VALUE) break block18;
                                throw new UnsupportedDicomObjectException("The original object size [" + this.originalObjectSize + "] is beyond the limits of JiveX.");
                                catch (NullPointerException nullPointerException) {
                                    throw DicomObject.a(nullPointerException);
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                throw DicomObject.a(nullPointerException);
                            }
                        }
                        this.originalObjectSize = l;
                        string = null;
                        if (ax2 == null) break block19;
                        string = ax2.aa();
                    }
                    String string2 = null;
                    aj2 = new aj(inputStream, (int)l, string);
                    if (((ai)aj2).af()) {
                        try {
                            this.fileMetaHeader = new ap();
                            this.fileMetaHeader.aa(aj2);
                            string2 = this.fileMetaHeader.ah();
                        }
                        catch (NullPointerException nullPointerException) {
                            throw new NoValidDicomObjectException("Can't decode data.", nullPointerException);
                        }
                    }
                    try {
                        this.parsedTransferSyntax = string2 == null ? aae.aa(aj2) : com.visustt.dicomTk.ab.ar.aa(string2);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw DicomObject.a(nullPointerException);
                    }
                    try {
                        if (this.parsedTransferSyntax == null) {
                            throw new UnsupportedTransferSyntaxException(string2);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        throw DicomObject.a(nullPointerException);
                    }
                    try {
                        try {
                            if (ax2 == null || !ax2.af()) break block20;
                            return;
                        }
                        catch (NullPointerException nullPointerException) {
                            throw DicomObject.a(nullPointerException);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        throw DicomObject.a(nullPointerException);
                    }
                }
                try {
                    if (dicomTag != null) break block21;
                    this.parsedTransferSyntax.aa(aj2, this.contents, ax2);
                    break block22;
                }
                catch (NullPointerException nullPointerException) {
                    throw DicomObject.a(nullPointerException);
                }
            }
            this.parsedTransferSyntax.aa(aj2, this.contents, ax2, dicomTag, bl, -1);
        }
        this.lastParsedTagPosition = (long)aj2.ad() - 4L;
        ((ai)aj2).ae();
    }

    protected void handleStreamFailed(byte[] byArray, com.visustt.dicomTk.ax ax2, String string, int n) throws NoValidDicomObjectException, UnsupportedTransferSyntaxException, UnsupportedDicomObjectException, CommonDicomException {
        ai ai2 = new ai(byArray);
        if (ai2.af()) {
            try {
                this.fileMetaHeader = new ap();
                this.fileMetaHeader.aa(ai2);
                string = this.fileMetaHeader.ah();
            }
            catch (NullPointerException nullPointerException) {
                throw new NoValidDicomObjectException("Can't decode data.", nullPointerException);
            }
        }
        try {
            this.parsedTransferSyntax = string == null ? aae.aa(ai2) : com.visustt.dicomTk.ab.ar.aa(string);
        }
        catch (NullPointerException nullPointerException) {
            throw DicomObject.a(nullPointerException);
        }
        try {
            if (this.parsedTransferSyntax == null) {
                throw new UnsupportedTransferSyntaxException(string);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw DicomObject.a(nullPointerException);
        }
        try {
            if (ax2.af()) {
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw DicomObject.a(nullPointerException);
        }
        try {
            this.parsedTransferSyntax.aa(ai2, this.contents, ax2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ai2.ae();
    }

    public DicomObject retrieveSelectedDicomElements(DicomTag[] dicomTagArray) {
        return this.retrieveSelectedDicomElements(Arrays.asList(dicomTagArray));
    }

    public void kill() {
        try {
            if (this.contents == null) {
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw DicomObject.a(nullPointerException);
        }
        for (int i = 0; i < this.contents.getSize(); ++i) {
            DicomElement dicomElement = this.contents.getDicomElementAt(i);
            dicomElement.kill();
        }
        this.contents.removeAll();
        this.contents = null;
    }

    public Object clone() {
        DicomObject dicomObject = new DicomObject((DicomElementList)this.contents.clone());
        dicomObject.setParsedTransferSyntax(this.parsedTransferSyntax);
        return dicomObject;
    }

    public void dumpToConsole() {
        try {
            this.dumpToStream(System.out);
        }
        catch (Exception exception) {
            logger.warn((Object)("Exception occurs while creating DICOM dump " + exception), exception);
        }
    }

    private void dumpToConsole(PrintStream printStream, DicomElementList dicomElementList, int n) {
        int n2 = dicomElementList.getSize();
        for (int i = 0; i < n2; ++i) {
            int n3;
            DicomElement dicomElement = dicomElementList.getDicomElementAt(i);
            try {
                for (n3 = 0; n3 < n; ++n3) {
                    printStream.print("| ");
                }
            }
            catch (Exception exception) {
                throw DicomObject.a(exception);
            }
            printStream.println(dicomElement);
            if (!(dicomElement instanceof av)) continue;
            n3 = dicomElement.getValueMultiplication();
            for (int j = 0; j < n3; ++j) {
                try {
                    int n4;
                    DicomElementList dicomElementList2 = dicomElement.getValueAsSequence(j);
                    try {
                        for (n4 = 0; n4 < n; ++n4) {
                            printStream.print("| ");
                        }
                    }
                    catch (Exception exception) {
                        throw DicomObject.a(exception);
                    }
                    printStream.print("|- ");
                    printStream.println("Item " + j);
                    this.dumpToConsole(printStream, dicomElementList2, n + 1);
                    try {
                        for (n4 = 0; n4 < n + 1; ++n4) {
                            printStream.print("| ");
                        }
                    }
                    catch (Exception exception) {
                        throw DicomObject.a(exception);
                    }
                    printStream.println();
                    continue;
                }
                catch (Exception exception) {
                    logger.warn((Object)("Exception occurs while creating DICOM dump " + exception), exception);
                }
            }
        }
    }

    public void dumpToStream(OutputStream outputStream) throws IOException {
        PrintStream printStream = new PrintStream(outputStream);
        try {
            if (this.fileMetaHeader != null) {
                printStream.println("Dicom Meta Information Header");
                this.dumpToConsole(printStream, this.fileMetaHeader.getDicomElementList(), 0);
            }
        }
        catch (IOException iOException) {
            throw DicomObject.a(iOException);
        }
        printStream.println("Dicom Data Set");
        printStream.println("Used Transfer Syntax " + this.getParsedTransferSyntax());
        this.dumpToConsole(printStream, this.contents, 0);
    }

    public void dumpToFile(String string, String string2) throws FileNotFoundException, IOException {
        File file = new File(string);
        try {
            if (!file.exists()) {
                file.mkdir();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw DicomObject.a(fileNotFoundException);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file + "/DcmDump_" + string2 + "_" + System.currentTimeMillis() + ".txt");
        this.dumpToStream(fileOutputStream);
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpToString(int n) {
        StringWriter stringWriter = new StringWriter();
        try {
            PrintWriter printWriter = new PrintWriter(stringWriter);
            try {
                if (this.fileMetaHeader != null) {
                    printWriter.println("Dicom Meta Information Header");
                    this.dumpToString(printWriter, this.fileMetaHeader.getDicomElementList(), 0);
                }
            }
            catch (Exception exception) {
                throw DicomObject.a(exception);
            }
            printWriter.println("Dicom Data Set");
            printWriter.println("Used Transfer Syntax " + this.getParsedTransferSyntax() + "\n");
            this.dumpToString(printWriter, this.contents, n);
            String string = stringWriter.getBuffer().toString();
            return string;
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (Exception exception) {
                logger.warn((Object)("Exception occurs while creating DICOM dump " + exception), exception);
            }
        }
    }

    private void dumpToString(PrintWriter printWriter, DicomElementList dicomElementList, int n) {
        int n2 = dicomElementList.getSize();
        for (int i = 0; i < n2; ++i) {
            int n3;
            DicomElement dicomElement = dicomElementList.getDicomElementAt(i);
            try {
                for (n3 = 0; n3 < n; ++n3) {
                    printWriter.print("| ");
                }
            }
            catch (Exception exception) {
                throw DicomObject.a(exception);
            }
            printWriter.println(dicomElement);
            if (!(dicomElement instanceof av)) continue;
            n3 = dicomElement.getValueMultiplication();
            for (int j = 0; j < n3; ++j) {
                try {
                    int n4;
                    DicomElementList dicomElementList2 = dicomElement.getValueAsSequence(j);
                    try {
                        for (n4 = 0; n4 < n; ++n4) {
                            printWriter.print("| ");
                        }
                    }
                    catch (Exception exception) {
                        throw DicomObject.a(exception);
                    }
                    printWriter.print("|- ");
                    printWriter.println("Item " + j);
                    this.dumpToString(printWriter, dicomElementList2, n + 1);
                    try {
                        for (n4 = 0; n4 < n + 1; ++n4) {
                            printWriter.print("| ");
                        }
                    }
                    catch (Exception exception) {
                        throw DicomObject.a(exception);
                    }
                    printWriter.println();
                    continue;
                }
                catch (Exception exception) {
                    logger.warn((Object)("Exception occurs while creating DICOM dump " + exception), exception);
                }
            }
        }
    }

    public String dumpToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.dumpToString(0));
        return stringBuffer.toString();
    }

    public static String dumpDicomElementVector(Vector<DicomElementList> vector) {
        StringBuffer stringBuffer;
        block5: {
            stringBuffer = new StringBuffer();
            try {
                if (vector == null || vector.size() <= 0) break block5;
            }
            catch (NullPointerException nullPointerException) {
                throw DicomObject.a(nullPointerException);
            }
            int n = vector.size();
            DicomObject dicomObject = new DicomObject(vector.elementAt(0));
            stringBuffer.append(dicomObject.dumpToString());
            try {
                for (int i = 1; i < n; ++i) {
                    dicomObject.setDicomElementList(vector.elementAt(i));
                    stringBuffer.append(dicomObject.dumpToString());
                }
            }
            catch (NullPointerException nullPointerException) {
                throw DicomObject.a(nullPointerException);
            }
        }
        return stringBuffer.toString();
    }

    public com.visustt.dicomTk.ab.ar getParsedTransferSyntax() {
        return this.parsedTransferSyntax;
    }

    public void setParsedTransferSyntax(com.visustt.dicomTk.ab.ar ar2) {
        this.parsedTransferSyntax = ar2;
    }

    public aw getSOPCommonModule() {
        try {
            if (this.sopCommonModule == null) {
                this.sopCommonModule = new aw(this.contents);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw DicomObject.a(nullPointerException);
        }
        return this.sopCommonModule;
    }

    public boolean isImageObjectIOD() {
        return this.contents.hasDicomElement(BaseDicomTagNames.TAG_pixelData);
    }

    private final String getSpecificCharacterSetValue() {
        String string;
        String string2 = null;
        DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_specificCharacterSet);
        if (dicomElement != null) {
            try {
                string2 = ((ax)dicomElement).ac();
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                // empty catch block
            }
        }
        try {
            string = StringTool.isDefined(string2) ? string2 : null;
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomObject.a(noValidValueIndexException);
        }
        return string;
    }

    private final void setSpecificCharacterSetValue() {
        com.visustt.dicomTk.aa.ak ak2 = new com.visustt.dicomTk.aa.ak();
        try {
            af af2 = ak2.aa();
            if (!ag.aa.equals(af2)) {
                DicomTag dicomTag = DicomTagNames.TAG_specificCharacterSet;
                String string = af2.aa();
                aam aam2 = new aam(dicomTag, string);
                this.getDicomElementList().insertDicomElement(aam2);
                this.getDicomElementList().setDefinedTerm(af2);
            }
        }
        catch (InvalidDataException invalidDataException) {
            invalidDataException.printStackTrace();
        }
    }

    public final void refreshSpecificCharacterSetValue() {
        this.setSpecificCharacterSetValue();
    }

    public static DicomObject getDicomHeader(File file, DicomTag dicomTag) throws IOException, CommonDicomException {
        byte[] byArray = StoreUtil.aa(file);
        return new DicomObject(byArray, dicomTag, true);
    }

    public long getOriginalObjectSize() {
        return this.originalObjectSize;
    }

    public long getLastParsedTagPosition() {
        return this.lastParsedTagPosition;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

