/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk;

import com.visustt.dicomTk.BaseDicomTagNames;
import com.visustt.dicomTk.DicomTag;
import com.visustt.dicomTk.ImageModule;
import com.visustt.dicomTk.NoValidValueIndexException;
import com.visustt.dicomTk.UnsupportedTransferSyntaxException;
import com.visustt.dicomTk.aa.aa;
import com.visustt.dicomTk.aa.af;
import com.visustt.dicomTk.aa.ah;
import com.visustt.dicomTk.ab.ar;
import com.visustt.dicomTk.aw;
import com.visustt.dicomTk.data.DicomElement;
import com.visustt.dicomTk.data.av;
import com.visustt.dicomTk.dict.DicomDictionary;
import com.visustt.dicomTk.dict.ElementInformation;
import com.visustt.dicomTk.util.az;
import com.visustt.tools.lang.ag;
import com.visustt.tools.util.ab.ab;
import java.util.Iterator;
import java.util.Objects;
import java.util.Vector;

public class DicomElementList
implements Cloneable,
Iterable<DicomElement> {
    protected final Vector<DicomElement> elements = new Vector(80);
    private ImageModule imageModule;
    private aw sopCommonModule;
    private az parsedImageInformation;
    private DicomTag parent = null;
    private af definedTerm;
    private boolean reachedCharsetTag = true;

    public static DicomElementList getCopy(DicomElementList dicomElementList, Vector<DicomTag> vector) {
        DicomElementList dicomElementList2 = new DicomElementList();
        for (int i = 0; i < dicomElementList.elements.size(); ++i) {
            DicomElement dicomElement = dicomElementList.elements.get(i);
            if (!vector.contains(dicomElement.getDicomTag())) continue;
            dicomElementList2.insertDicomElement((DicomElement)dicomElement.clone());
        }
        return dicomElementList2;
    }

    public Vector<DicomElement> getDicomElements() {
        return this.elements;
    }

    private final void addObject(DicomElement dicomElement) {
        int n = this.elements.size();
        if (n > 0) {
            DicomElement dicomElement2 = this.elements.lastElement();
            int n2 = dicomElement2.compareTo(dicomElement);
            if (n2 > 0) {
                this.elements.addElement(dicomElement);
                dicomElement.setDicomElements(this);
                return;
            }
            int n3 = this.getElementIndex(dicomElement.getDicomTag());
            if (n3 != -1) {
                DicomElement dicomElement3 = this.elements.get(n3);
                dicomElement3.setDicomElements(null);
                if (dicomElement instanceof av) {
                    this.elements.remove(n3);
                    --n;
                } else {
                    this.elements.setElementAt(dicomElement, n3);
                    dicomElement.setDicomElements(this);
                    return;
                }
            }
            int n4 = 0;
            if (!this.elements.isEmpty()) {
                DicomElement dicomElement4 = this.elements.elementAt(0);
                while (n4 < n - 1 && dicomElement4.compareTo(dicomElement) > 0) {
                    dicomElement4 = this.elements.elementAt(++n4);
                }
                if (dicomElement4.compareTo(dicomElement) > 0) {
                    ++n4;
                }
            }
            this.elements.insertElementAt(dicomElement, n4);
            dicomElement.setDicomElements(this);
        } else {
            this.elements.addElement(dicomElement);
        }
        dicomElement.setDicomElements(this);
    }

    private void removeObject(DicomElement dicomElement) {
        if (dicomElement != null) {
            this.elements.removeElement(dicomElement);
            dicomElement.setDicomElements(null);
        }
    }

    public void removeAll() {
        this.elements.removeAllElements();
    }

    public int getSize() {
        return this.elements.size();
    }

    private final DicomElement getElementLike(DicomTag dicomTag) {
        if (dicomTag == null) {
            return null;
        }
        int n = 0;
        int n2 = this.elements.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            DicomElement dicomElement = this.elements.elementAt(n3);
            int n4 = dicomElement.getDicomTag().compareTo(dicomTag);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 != 0) continue;
            return dicomElement;
        }
        return null;
    }

    private final int getElementIndex(DicomTag dicomTag) {
        if (dicomTag == null) {
            return -1;
        }
        int n = 0;
        int n2 = this.elements.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            DicomElement dicomElement = this.elements.elementAt(n3);
            int n4 = dicomElement.getDicomTag().compareTo(dicomTag);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 != 0) continue;
            return n3;
        }
        return -1;
    }

    public final boolean hasDicomElement(long l) {
        return this.hasDicomElement(new DicomTag(l));
    }

    public final boolean hasDicomElement(DicomTag dicomTag) {
        return this.getElementLike(dicomTag) != null;
    }

    public final DicomElement getDicomElement(long l) {
        return this.getElementLike(new DicomTag(l));
    }

    public DicomElement getDicomElement(DicomTag dicomTag) {
        return this.getElementLike(dicomTag);
    }

    public DicomElement getDicomElementAt(int n) {
        return this.elements.elementAt(n);
    }

    public DicomElementList insertDicomElement(DicomElement dicomElement) {
        if (dicomElement != null) {
            this.addObject(dicomElement);
        }
        return this;
    }

    public void removeDicomElement(DicomElement dicomElement) {
        this.removeObject(dicomElement);
    }

    public void removeDicomElement(DicomTag dicomTag) {
        this.removeObject(this.getDicomElement(dicomTag));
    }

    public Object clone() {
        DicomElementList dicomElementList = new DicomElementList();
        try {
            int n = this.elements.size();
            try {
                for (int i = 0; i < n; ++i) {
                    dicomElementList.insertDicomElement((DicomElement)this.getDicomElementAt(i).clone());
                }
            }
            catch (Exception exception) {
                throw DicomElementList.a(exception);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return dicomElementList;
    }

    public void addAttribute(DicomTag dicomTag) {
        DicomElement dicomElement = null;
        ElementInformation elementInformation = DicomDictionary.instance().searchElement(dicomTag);
        dicomElement = elementInformation == null ? ElementInformation.createElement("UN", dicomTag) : elementInformation.createElement();
        this.insertDicomElement(dicomElement);
    }

    public ImageModule getImageModule() {
        if (this.imageModule == null) {
            this.imageModule = new ImageModule(this);
        }
        return this.imageModule;
    }

    public aw getSOPCommonModule() {
        if (this.sopCommonModule == null) {
            this.sopCommonModule = new aw(this);
        }
        return this.sopCommonModule;
    }

    public int getByteArraySizeForAllElements(String string) throws UnsupportedTransferSyntaxException {
        try {
            if (!ar.ab(string)) {
                throw new UnsupportedTransferSyntaxException();
            }
        }
        catch (UnsupportedTransferSyntaxException unsupportedTransferSyntaxException) {
            throw DicomElementList.a(unsupportedTransferSyntaxException);
        }
        return this.getByteArraySizeForAllElements(ar.aa(string));
    }

    public int getByteArraySizeForAllElements(ar ar2) {
        int n = this.getSize();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.getDicomElementAt(i).getNumberOfBytesInStream(ar2);
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    public int removePrivateTags() {
        var1_1 = 0;
        var2_2 = 0;
        while (var2_2 < this.getSize()) {
            block17: {
                block18: {
                    block19: {
                        var3_3 = this.getDicomElementAt(var2_2);
                        var4_4 = var3_3.getDicomTag().getGroupNumber();
                        if (var4_4 % 2 == 0) break block17;
                        if (var4_4 < 9) ** GOTO lbl19
                        break block19;
                        catch (NoValidValueIndexException v0) {
                            throw DicomElementList.a(v0);
                        }
                    }
                    try {
                        block20: {
                            if (var4_4 != 65535) break block18;
                            break block20;
                            catch (NoValidValueIndexException v1) {
                                throw DicomElementList.a(v1);
                            }
                        }
                        ++var2_2;
                        continue;
                    }
                    catch (NoValidValueIndexException v2) {
                        throw DicomElementList.a(v2);
                    }
                }
                this.removeDicomElement(var3_3);
                ++var1_1;
                continue;
            }
            if (var3_3 instanceof av) {
                var5_5 = (av)var3_3;
                var6_6 = 0;
                while (var6_6 < var5_5.af()) {
                    try {
                        var7_7 = var5_5.ac(var6_6);
                        var1_1 += var7_7.removePrivateTags();
                        try {
                            if (var7_7.getSize() == 0) {
                                var5_5.ad(var6_6);
                                ++var1_1;
                                continue;
                            }
                        }
                        catch (NoValidValueIndexException v3) {
                            throw DicomElementList.a(v3);
                        }
                        ++var6_6;
                    }
                    catch (NoValidValueIndexException var7_8) {
                        ++var6_6;
                    }
                }
                try {
                    if (var5_5.af() == 0) {
                        this.removeDicomElement(var3_3);
                        ++var1_1;
                        continue;
                    }
                }
                catch (NoValidValueIndexException v4) {
                    throw DicomElementList.a(v4);
                }
                ++var2_2;
                continue;
            }
            ++var2_2;
        }
        return var1_1;
    }

    public void removeUnknownTags() {
        DicomDictionary dicomDictionary = DicomDictionary.instance();
        int n = 0;
        while (n < this.getSize()) {
            DicomElement dicomElement = this.getDicomElementAt(n);
            if (dicomDictionary.searchElement(dicomElement.getDicomTag()) == null) {
                this.removeDicomElement(dicomElement);
                continue;
            }
            ++n;
        }
    }

    public az getParsedImageInformation() {
        return this.parsedImageInformation;
    }

    public void setParsedImageInformation(az az2) {
        this.parsedImageInformation = az2;
    }

    public String toString() {
        return "[Element Count:" + this.getDicomElements().size() + "]" + super.toString();
    }

    public String dumpToString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (DicomElement dicomElement : this.elements) {
            stringBuilder.append(dicomElement);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public af getDefinedTerm() {
        if (!ab.aa() && this.definedTerm == null && this.isReachedCharsetTag()) {
            aa aa10 = this.readSpecificCharacterSet();
            this.definedTerm = ah.aa(aa10);
        }
        return this.definedTerm;
    }

    public final void setDefinedTerm(af af2) {
        if (!ab.aa()) {
            this.definedTerm = af2;
        }
    }

    private final aa readSpecificCharacterSet() {
        String[] stringArray;
        aa aa10 = null;
        DicomElement dicomElement = this.getDicomElement(BaseDicomTagNames.TAG_specificCharacterSet);
        if (dicomElement != null && (stringArray = dicomElement.getValues()) != null && stringArray.length > 0) {
            aa10 = aa.ab(stringArray[0]);
            if (stringArray.length > 1 && aa.ac().equals((Object)aa10)) {
                aa10 = aa.ISO_2022_IR_6;
            }
        }
        return aa10 != null ? aa10 : aa.ac();
    }

    public final boolean isReachedCharsetTag() {
        return this.reachedCharsetTag;
    }

    public final void setReachedCharsetTag(boolean bl) {
        this.reachedCharsetTag = bl;
    }

    @Override
    public Iterator<DicomElement> iterator() {
        return this.elements.iterator();
    }

    public DicomTag getParent() {
        return this.parent;
    }

    public void setParent(DicomTag dicomTag) {
        this.parent = dicomTag;
    }

    public final int hashCode() {
        return new ag().aa((Object)this.parent).aa((Object)this.elements).aa();
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DicomElementList dicomElementList = (DicomElementList)object;
        return Objects.equals(this.parent, dicomElementList.parent) && this.elements.size() == dicomElementList.elements.size() && Objects.equals(this.elements, dicomElementList.elements);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

