/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk;

import com.visustt.dicomTk.CommonDicomException;
import com.visustt.dicomTk.DicomElementList;
import com.visustt.dicomTk.DicomTag;
import com.visustt.dicomTk.InvalidDataException;
import com.visustt.dicomTk.NoValidValueIndexException;
import com.visustt.dicomTk.UnavailableException;
import com.visustt.dicomTk.data.DicomElement;
import com.visustt.dicomTk.dict.DicomDictionary;
import com.visustt.dicomTk.dict.ElementInformation;
import java.util.Date;
import java.util.Vector;

public class BaseDicomModule {
    protected DicomElementList contents;

    public BaseDicomModule() {
        this((DicomElementList)null);
    }

    public BaseDicomModule(BaseDicomModule baseDicomModule) {
        this(baseDicomModule != null ? baseDicomModule.getDicomElementList() : (DicomElementList)null);
    }

    public BaseDicomModule(DicomElementList dicomElementList) {
        this.contents = dicomElementList != null ? dicomElementList : new DicomElementList();
        this.contents.setReachedCharsetTag(true);
    }

    public void setDicomElementList(DicomElementList dicomElementList) {
        this.contents = dicomElementList;
    }

    public DicomElementList getDicomElementList() {
        return this.contents;
    }

    public boolean existsDicomElement(DicomTag dicomTag) {
        return this.contents.hasDicomElement(dicomTag);
    }

    public boolean existsDicomElementWithAtLeastOneValue(DicomTag dicomTag) {
        DicomElement dicomElement = this.contents.getDicomElement(dicomTag);
        if (dicomElement == null) {
            return false;
        }
        return dicomElement.getValueMultiplication() != 0;
    }

    public boolean existsDicomElement(long l) {
        return this.contents.hasDicomElement(l);
    }

    public DicomElement getDicomElement(DicomTag dicomTag) {
        return this.contents.getDicomElement(dicomTag);
    }

    public DicomElement getDicomElement(long l) {
        return this.contents.getDicomElement(new DicomTag(l));
    }

    public void removeDicomElement(DicomTag dicomTag) {
        this.contents.removeDicomElement(this.getDicomElement(dicomTag));
    }

    public void insertDicomElement(DicomElement dicomElement) {
        if (dicomElement == null) {
            return;
        }
        this.contents.insertDicomElement(dicomElement);
    }

    public byte[] getBytes(DicomTag dicomTag) {
        DicomElement dicomElement = this.contents.getDicomElement(dicomTag);
        if (dicomElement == null) {
            return null;
        }
        return dicomElement.getValueAsByteArray();
    }

    public Date getDate(DicomTag dicomTag) {
        DicomElement dicomElement = this.contents.getDicomElement(dicomTag);
        try {
            if (dicomElement == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw BaseDicomModule.b(exception);
        }
        try {
            return dicomElement.getValueAsDate(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Long getLong(DicomTag dicomTag) {
        try {
            return this.getLong(dicomTag, 0);
        }
        catch (InvalidDataException invalidDataException) {
            return null;
        }
    }

    public Long getLong(DicomTag dicomTag, int n) throws InvalidDataException {
        DicomElement dicomElement = this.contents.getDicomElement(dicomTag);
        try {
            if (dicomElement == null) {
                throw new UnavailableException("DicomTag: " + dicomTag);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw BaseDicomModule.b(noValidValueIndexException);
        }
        try {
            return dicomElement.getValueAsLong(n);
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw new UnavailableException("No Value for DicomTag: " + dicomTag);
        }
    }

    public int getInt(DicomTag dicomTag) throws InvalidDataException {
        return this.getInt(dicomTag, 0);
    }

    public int getInt(DicomTag dicomTag, int n) throws InvalidDataException {
        DicomElement dicomElement = this.contents.getDicomElement(dicomTag);
        try {
            if (dicomElement == null) {
                throw new UnavailableException("DicomTag: " + dicomTag);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw BaseDicomModule.b(noValidValueIndexException);
        }
        try {
            return dicomElement.getValueAsInt(n);
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw new UnavailableException("No Value for DicomTag: " + dicomTag);
        }
    }

    public Float getFloat(DicomTag dicomTag) {
        return this.getFloat(dicomTag, 0);
    }

    public Float getFloat(DicomTag dicomTag, int n) {
        DicomElement dicomElement = this.contents.getDicomElement(dicomTag);
        try {
            if (dicomElement == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw BaseDicomModule.b(exception);
        }
        try {
            return Float.valueOf("" + dicomElement.getValueAsFloat(n));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Double getDouble(DicomTag dicomTag) {
        return this.getDouble(dicomTag, 0);
    }

    public Double getDouble(DicomTag dicomTag, int n) {
        DicomElement dicomElement = this.contents.getDicomElement(dicomTag);
        try {
            if (dicomElement == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw BaseDicomModule.b(exception);
        }
        try {
            return dicomElement.getValueAsDouble(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getString(DicomTag dicomTag) {
        return this.getString(dicomTag, 0);
    }

    public String getString(DicomTag dicomTag, int n) {
        DicomElement dicomElement = this.contents.getDicomElement(dicomTag);
        try {
            if (dicomElement == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw BaseDicomModule.b(exception);
        }
        try {
            String string;
            String string2 = dicomElement.getValueAsString(n);
            try {
                string = string2 == null ? null : string2.trim();
            }
            catch (Exception exception) {
                throw BaseDicomModule.b(exception);
            }
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object[] getValues(DicomTag dicomTag) {
        DicomElement dicomElement = this.contents.getDicomElement(dicomTag);
        try {
            if (dicomElement == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw BaseDicomModule.b(exception);
        }
        try {
            return dicomElement.getElementValues();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void clear() {
        this.contents.removeAll();
    }

    public Vector<DicomTag> getAttributes() {
        Vector<DicomTag> vector = new Vector<DicomTag>();
        int n = this.contents.getSize();
        for (int i = 0; i < n; ++i) {
            vector.add(this.contents.getDicomElementAt(i).getDicomTag());
        }
        return vector;
    }

    public void addAttribute(DicomTag dicomTag) throws CommonDicomException {
        ElementInformation elementInformation = DicomDictionary.instance().searchElement(dicomTag);
        DicomElement dicomElement = null;
        dicomElement = elementInformation == null ? ElementInformation.createElement("UN", dicomTag) : elementInformation.createElement();
        this.insertDicomElement(dicomElement);
    }

    public void addDicomElementList(DicomElementList dicomElementList) {
        int n = dicomElementList.getSize();
        for (int i = 0; i < n; ++i) {
            this.insertDicomElement(dicomElementList.getDicomElementAt(i).cloneAndSetDicomElementList(this.contents));
        }
    }

    public static boolean isDefined(long l) {
        return l != 0L;
    }

    public static boolean isDefined(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            return !"".equals(object);
        }
        if (object instanceof Long) {
            return BaseDicomModule.isDefined((Long)object);
        }
        if (object instanceof Short) {
            return BaseDicomModule.isDefined(((Short)object).shortValue());
        }
        if (object instanceof Integer) {
            return BaseDicomModule.isDefined(((Integer)object).intValue());
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":\n elements:" + (String)(this.contents != null ? "\n" + this.contents.dumpToString() : " null");
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

