/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jni.registry;

import com.ice.jni.registry.NoSuchKeyException;
import com.ice.jni.registry.NoSuchValueException;
import com.ice.jni.registry.RegistryException;
import com.ice.jni.registry.RegistryValue;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class RegistryKey {
    public static final int ACCESS_DEFAULT = 0;
    public static final int ACCESS_READ = 1;
    public static final int ACCESS_WRITE = 2;
    public static final int ACCESS_EXECUTE = 3;
    public static final int ACCESS_ALL = 4;
    private static Object syncObject = new Object();
    private static Logger logger = LoggerFactory.getInstance("jx.util.registry");
    protected int hKey;
    protected String name;
    protected boolean created;
    private boolean closeKeyFinalize = false;

    public RegistryKey(int n, String string) {
        this.hKey = n;
        this.name = string;
        this.created = false;
        logger.debug("created key " + string);
    }

    public RegistryKey(int n, String string, boolean bl) {
        this.hKey = n;
        this.name = string;
        this.created = bl;
        logger.debug("created key " + string);
    }

    public void finalize() {
        if (this.name.indexOf("\\") > 0 && !this.closeKeyFinalize) {
            logger.warn("registry key '" + this.getFullName() + "' closed by GC. This could cause a java.io.IOException: The handle is invalid (see#4323)");
            this.closeKeyFinalize();
        }
    }

    public Object getSyncObject() {
        return syncObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeKeyFinalize() {
        Object object = this.getSyncObject();
        synchronized (object) {
            if (!this.closeKeyFinalize) {
                try {
                    logger.debug("closing key " + this.getFullName());
                    this.closeKey();
                    this.closeKeyFinalize = true;
                }
                catch (RegistryException registryException) {
                    logger.debug((Object)("closeKey failed:" + registryException), registryException);
                }
            }
        }
    }

    public String getName() {
        int n = this.name.lastIndexOf("\\");
        if (n < 0) {
            return this.name;
        }
        return this.name.substring(n + 1);
    }

    public String getFullName() {
        return this.name;
    }

    public boolean wasCreated() {
        return this.created;
    }

    public void setCreated(boolean bl) {
        this.created = bl;
    }

    public RegistryKey openSubKey(String string) throws NoSuchKeyException, RegistryException {
        try {
            return this.openSubKey(string, 1);
        }
        catch (Error error) {
            try {
                if (error instanceof ThreadDeath) {
                    throw (ThreadDeath)error;
                }
            }
            catch (Error error2) {
                throw RegistryKey.a(error2);
            }
            RegistryException registryException = new RegistryException(error.getMessage());
            registryException.initCause(error);
            throw registryException;
        }
    }

    public RegistryKey createSubKey(String string, String string2) throws RegistryException {
        logger.debug("created subkey " + string);
        return this.createSubKey(string, string2, 2);
    }

    public void setValue(RegistryValue registryValue) throws RegistryException {
        this.setValue(registryValue.getName(), registryValue);
    }

    public native RegistryKey openSubKey(String var1, int var2) throws NoSuchKeyException, RegistryException;

    public native RegistryKey connectRegistry(String var1) throws NoSuchKeyException, RegistryException;

    public native RegistryKey createSubKey(String var1, String var2, int var3) throws RegistryException;

    public native void closeKey() throws RegistryException;

    public native void deleteSubKey(String var1) throws NoSuchKeyException, RegistryException;

    public native void deleteValue(String var1) throws NoSuchValueException, RegistryException;

    public native void flushKey() throws RegistryException;

    public native void setValue(String var1, RegistryValue var2) throws RegistryException;

    public native RegistryValue getValue(String var1) throws NoSuchValueException, RegistryException;

    public native String getStringValue(String var1) throws NoSuchValueException, RegistryException;

    public native String getDefaultValue() throws NoSuchValueException, RegistryException;

    public native boolean hasDefaultValue() throws RegistryException;

    public native boolean hasOnlyDefaultValue() throws RegistryException;

    public native int getNumberSubkeys() throws RegistryException;

    public native int getMaxSubkeyLength() throws RegistryException;

    public native String regEnumKey(int var1) throws RegistryException;

    public native int getNumberValues() throws RegistryException;

    public native int getMaxValueDataLength() throws RegistryException;

    public native int getMaxValueNameLength() throws RegistryException;

    public native String regEnumValue(int var1) throws RegistryException;

    public native int incrDoubleWord(String var1) throws NoSuchValueException, RegistryException;

    public native int decrDoubleWord(String var1) throws NoSuchValueException, RegistryException;

    public static native String expandEnvStrings(String var0);

    public Enumeration keyElements() throws RegistryException {
        return new RegistryKeyEnumerator(this);
    }

    public Enumeration valueElements() throws RegistryException {
        return new RegistryValueEnumerator(this);
    }

    public void export(PrintWriter printWriter, boolean bl) throws NoSuchKeyException, RegistryException {
        Object object;
        String string;
        printWriter.println("[" + this.getFullName() + "]");
        Enumeration enumeration = this.valueElements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.getValue(string);
            ((RegistryValue)object).export(printWriter);
        }
        printWriter.println("");
        if (bl) {
            enumeration = this.keyElements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                object = this.openSubKey(string);
                ((RegistryKey)object).export(printWriter, bl);
                ((RegistryKey)object).closeKey();
            }
        }
    }

    private static Error a(Error error) {
        return error;
    }

    class RegistryKeyEnumerator
    implements Enumeration {
        RegistryKey key;
        int currIndex;
        int numSubKeys;

        public RegistryKeyEnumerator(RegistryKey registryKey2) throws RegistryException {
            this.key = registryKey2;
            this.currIndex = 0;
            this.numSubKeys = registryKey2.getNumberSubkeys();
        }

        @Override
        public boolean hasMoreElements() {
            boolean bl;
            try {
                bl = this.currIndex < this.numSubKeys;
            }
            catch (NoSuchElementException noSuchElementException) {
                throw RegistryKeyEnumerator.a(noSuchElementException);
            }
            return bl;
        }

        public Object nextElement() {
            String string = null;
            try {
                string = this.key.regEnumKey(this.currIndex++);
            }
            catch (RegistryException registryException) {
                throw new NoSuchElementException(registryException.getMessage());
            }
            return string;
        }

        private static NoSuchElementException a(NoSuchElementException noSuchElementException) {
            return noSuchElementException;
        }
    }

    class RegistryValueEnumerator
    implements Enumeration {
        RegistryKey key;
        int currIndex;
        int numValues;

        public RegistryValueEnumerator(RegistryKey registryKey2) throws RegistryException {
            this.key = registryKey2;
            this.currIndex = 0;
            this.numValues = registryKey2.getNumberValues();
        }

        @Override
        public boolean hasMoreElements() {
            boolean bl;
            try {
                bl = this.currIndex < this.numValues;
            }
            catch (NoSuchElementException noSuchElementException) {
                throw RegistryValueEnumerator.a(noSuchElementException);
            }
            return bl;
        }

        public Object nextElement() {
            String string = null;
            try {
                string = this.key.regEnumValue(this.currIndex++);
            }
            catch (RegistryException registryException) {
                throw new NoSuchElementException(registryException.getMessage());
            }
            return string;
        }

        private static NoSuchElementException a(NoSuchElementException noSuchElementException) {
            return noSuchElementException;
        }
    }
}

