/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.pdfrenderer;

import com.sun.pdfview.Flag;
import com.sun.pdfview.PDFPage;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class VisusPagePanel
extends JPanel
implements ImageObserver,
MouseListener,
MouseMotionListener {
    public static final String PROPERTY_ZOOM_TOOL = "ZOOM_TOOL";
    public static final String PROPERTY_SNAPSHOT_TOOL = "SNAPSHOT_TOOL";
    private static final long serialVersionUID = -1712817903461870456L;
    Image currentImage;
    Image snapshotImage;
    PDFPage currentPage;
    AffineTransform currentXform;
    int offx;
    int offy;
    Rectangle2D clip;
    Rectangle2D prevClip;
    Dimension prevSize;
    private Rectangle selectionRect;
    private boolean useZoom = false;
    private boolean useSnapshot = false;
    private int selectionThreshold = 5;
    private Color selectionInlineColor = new Color(0, 0, 255, 125);
    private Color selectionOutlineColor = Color.BLUE;
    Flag flag = new Flag();
    int downx;
    int downy;

    public VisusPagePanel() {
        this.setPreferredSize(new Dimension(800, 600));
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public synchronized void showPage(PDFPage page) {
        if (this.currentPage != null && this.prevSize != null) {
            this.currentPage.stop(this.prevSize.width, this.prevSize.height, this.prevClip);
        }
        this.currentPage = page;
        if (page == null) {
            this.currentImage = null;
            this.clip = null;
            this.currentXform = null;
            this.repaint();
        } else {
            this.flag.clear();
            Dimension sz = this.getSize();
            if (sz.width + sz.height == 0) {
                return;
            }
            Rectangle2D useClip = this.clip;
            if (this.clip != null && this.currentXform != null) {
                useClip = this.currentXform.createTransformedShape(this.clip).getBounds2D();
            }
            Dimension pageSize = page.getUnstretchedSize(sz.width, sz.height, useClip);
            this.currentImage = page.getImage(pageSize.width, pageSize.height, useClip, this);
            this.currentXform = page.getInitialTransform(pageSize.width, pageSize.height, useClip);
            try {
                this.currentXform = this.currentXform.createInverse();
            }
            catch (NoninvertibleTransformException nte) {
                System.out.println("Error inverting page transform!");
                nte.printStackTrace();
            }
            this.prevClip = useClip;
            this.prevSize = pageSize;
            this.repaint();
        }
    }

    public synchronized void flush() {
    }

    public void paint(Graphics g) {
        Dimension sz = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.currentImage == null) {
            g.setColor(Color.GRAY);
            g.drawString("No page selected", this.getWidth() / 2 - 30, this.getHeight() / 2);
        } else {
            int imwid = this.currentImage.getWidth(null);
            int imhgt = this.currentImage.getHeight(null);
            this.offx = (sz.width - imwid) / 2;
            this.offy = (sz.height - imhgt) / 2;
            if (imwid == sz.width && imhgt <= sz.height || imhgt == sz.height && imwid <= sz.width) {
                g.drawImage(this.currentImage, this.offx, this.offy, this);
            } else if (this.currentPage != null) {
                this.showPage(this.currentPage);
            }
        }
        if (this.selectionRect != null) {
            Color oldColor = g.getColor();
            g.setColor(this.selectionInlineColor);
            g.fillRect(this.selectionRect.x, this.selectionRect.y, this.selectionRect.width, this.selectionRect.height);
            g.setColor(this.selectionOutlineColor);
            g.drawRect(this.selectionRect.x, this.selectionRect.y, this.selectionRect.width, this.selectionRect.height);
            g.setColor(oldColor);
        }
    }

    public PDFPage getPage() {
        return this.currentPage;
    }

    public Dimension getCurSize() {
        return this.prevSize;
    }

    public Rectangle2D getCurClip() {
        return this.prevClip;
    }

    public void waitForCurrentPage() {
        this.flag.waitForFlag();
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x28) != 0) {
            this.repaint(x + this.offx, y + this.offy, width, height);
        }
        if ((infoflags & 0xE0) != 0) {
            this.flag.set();
            return false;
        }
        return true;
    }

    public void useZoomTool(boolean use) {
        if (this.useZoom == use) {
            return;
        }
        boolean oldValue = this.useZoom;
        this.useZoom = use;
        if (this.useZoom && this.useSnapshot) {
            this.useSnapshot = false;
        }
        Cursor cursor = null;
        if (this.useZoom) {
            cursor = Cursor.getPredefinedCursor(1);
        }
        this.setCursor(cursor);
        this.firePropertyChange(PROPERTY_ZOOM_TOOL, (Object)oldValue, (Object)this.useZoom);
    }

    public void useSnapshotTool(boolean use) {
        if (this.useSnapshot == use) {
            return;
        }
        boolean oldValue = this.useSnapshot;
        this.useSnapshot = use;
        if (this.useSnapshot && this.useZoom) {
            this.useZoom = false;
        }
        Cursor cursor = null;
        if (this.useSnapshot) {
            cursor = Cursor.getPredefinedCursor(1);
        }
        this.setCursor(cursor);
        this.firePropertyChange(PROPERTY_SNAPSHOT_TOOL, (Object)oldValue, (Object)this.useSnapshot);
    }

    public void setClip(Rectangle2D clip) {
        this.clip = clip;
        this.showPage(this.currentPage);
    }

    public void mousePressed(MouseEvent evt) {
        this.downx = evt.getX();
        this.downy = evt.getY();
    }

    public void mouseReleased(MouseEvent evt) {
        if (!this.useSnapshot && !this.useZoom) {
            this.selectionRect = null;
            return;
        }
        if ((this.useSnapshot || this.useZoom) && (this.selectionRect == null || this.selectionRect.width == 0 || this.selectionRect.height == 0)) {
            System.err.println("Zoo/Snapshot Tool activated but no selection is done!");
            this.selectionRect = null;
            return;
        }
        Rectangle2D clipRegion = new Rectangle2D.Double(this.selectionRect.x - this.offx, this.selectionRect.y - this.offy, this.selectionRect.width, this.selectionRect.height);
        if (this.useZoom) {
            this.setClip(clipRegion);
            this.selectionRect = null;
            return;
        }
        if (this.useSnapshot && this.currentPage != null) {
            Dimension sz = this.getSize();
            if (sz.width + sz.height == 0) {
                this.useSnapshotTool(false);
                this.selectionRect = null;
                return;
            }
            if (clipRegion != null && this.currentXform != null) {
                clipRegion = this.currentXform.createTransformedShape(clipRegion).getBounds2D();
            }
            Dimension pageSize = this.currentPage.getUnstretchedSize(sz.width, sz.height, clipRegion);
            this.snapshotImage = this.currentPage.getImage(pageSize.width, pageSize.height, clipRegion, null);
            if (Boolean.getBoolean("com.sun.pdfview.PagePanel.saveSnaphotImage")) {
                try {
                    File tempFile = File.createTempFile("pdf-snapshot", ".png");
                    ImageIO.write((RenderedImage)((Object)this.snapshotImage), "png", tempFile);
                    System.out.println("Wrote snapshot to file:" + tempFile.getAbsolutePath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.useSnapshotTool(false);
            this.selectionRect = null;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.useZoom || this.useSnapshot) {
            int x = evt.getX();
            int y = evt.getY();
            int dx = Math.abs(x - this.downx);
            int dy = Math.abs(y - this.downy);
            if ((evt.getModifiers() & 1) == 0) {
                float aspect = (float)dx / (float)dy;
                float waspect = (float)this.getWidth() / (float)this.getHeight();
                if (aspect > waspect) {
                    dy = (int)((float)dx / waspect);
                } else {
                    dx = (int)((float)dy * waspect);
                }
            }
            if (x < this.downx) {
                x = this.downx - dx;
            }
            if (y < this.downy) {
                y = this.downy - dy;
            }
            Rectangle old = this.selectionRect;
            this.selectionRect = dx < this.selectionThreshold || dy < this.selectionThreshold ? null : new Rectangle(Math.min(this.downx, x), Math.min(this.downy, y), dx, dy);
            if (this.selectionRect != null) {
                if (old != null) {
                    old.add(this.selectionRect);
                } else {
                    old = new Rectangle(this.selectionRect);
                }
            }
            if (old != null) {
                ++old.width;
                ++old.height;
            }
            if (old != null) {
                this.repaint(old);
            }
        }
    }

    public Image getSnapshotImage() {
        return this.snapshotImage;
    }

    public void clearSnapshotImage() {
        this.snapshotImage = null;
    }
}

