/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.pattern;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPaint;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.function.PDFFunction;
import com.sun.pdfview.pattern.PDFShader;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class ShaderType2
extends PDFShader {
    private Point2D axisStart;
    private Point2D axisEnd;
    private float minT = 0.0f;
    private float maxT = 1.0f;
    private boolean extendStart = false;
    private boolean extendEnd = false;
    private PDFFunction[] functions;

    public ShaderType2() {
        super(2);
    }

    public void parse(PDFObject shaderObj) throws IOException {
        PDFObject functionObj;
        PDFObject coordsObj = shaderObj.getDictRef("Coords");
        if (coordsObj == null) {
            throw new PDFParseException("No coordinates found!");
        }
        PDFObject[] coords = coordsObj.getArray();
        Point2D.Float start = new Point2D.Float(coords[0].getFloatValue(), coords[1].getFloatValue());
        Point2D.Float end = new Point2D.Float(coords[2].getFloatValue(), coords[3].getFloatValue());
        this.setAxisStart(start);
        this.setAxisEnd(end);
        PDFObject domainObj = shaderObj.getDictRef("Domain");
        if (domainObj != null) {
            PDFObject[] domain = domainObj.getArray();
            this.setMinT(domain[0].getFloatValue());
            this.setMaxT(domain[1].getFloatValue());
        }
        if ((functionObj = shaderObj.getDictRef("Function")) == null) {
            throw new PDFParseException("No function defined for shader!");
        }
        PDFObject[] functionArray = functionObj.getArray();
        PDFFunction[] functions = new PDFFunction[functionArray.length];
        int i = 0;
        while (i < functions.length) {
            functions[i] = PDFFunction.getFunction(functionArray[i]);
            ++i;
        }
        this.setFunctions(functions);
        PDFObject extendObj = shaderObj.getDictRef("Extend");
        if (extendObj != null) {
            PDFObject[] extendArray = extendObj.getArray();
            this.setExtendStart(extendArray[0].getBooleanValue());
            this.setExtendEnd(extendArray[1].getBooleanValue());
        }
    }

    public PDFPaint getPaint() {
        return PDFPaint.getPaint(new Type2Paint());
    }

    public Point2D getAxisStart() {
        return this.axisStart;
    }

    protected void setAxisStart(Point2D axisStart) {
        this.axisStart = axisStart;
    }

    public Point2D getAxisEnd() {
        return this.axisEnd;
    }

    protected void setAxisEnd(Point2D axisEnd) {
        this.axisEnd = axisEnd;
    }

    public float getMinT() {
        return this.minT;
    }

    protected void setMinT(float minT) {
        this.minT = minT;
    }

    public float getMaxT() {
        return this.maxT;
    }

    protected void setMaxT(float maxT) {
        this.maxT = maxT;
    }

    public boolean getExtendStart() {
        return this.extendStart;
    }

    protected void setExtendStart(boolean extendStart) {
        this.extendStart = extendStart;
    }

    public boolean getExtendEnd() {
        return this.extendEnd;
    }

    protected void setExtendEnd(boolean extendEnd) {
        this.extendEnd = extendEnd;
    }

    public PDFFunction[] getFunctions() {
        return this.functions;
    }

    protected void setFunctions(PDFFunction[] functions) {
        this.functions = functions;
    }

    class Type2Paint
    implements Paint {
        public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            ColorSpace cs = ColorSpace.getInstance(1000);
            ComponentColorModel model = new ComponentColorModel(cs, true, false, 3, 0);
            Point2D devStart = xform.transform(ShaderType2.this.getAxisStart(), null);
            Point2D devEnd = xform.transform(ShaderType2.this.getAxisEnd(), null);
            return new Type2PaintContext(model, devStart, devEnd);
        }

        public int getTransparency() {
            return 3;
        }
    }

    class Type2PaintContext
    implements PaintContext {
        private ColorModel colorModel;
        private Point2D start;
        private Point2D end;

        Type2PaintContext(ColorModel colorModel, Point2D start, Point2D end) {
            this.colorModel = colorModel;
            this.start = start;
            this.end = end;
        }

        public void dispose() {
            this.colorModel = null;
        }

        public ColorModel getColorModel() {
            return this.colorModel;
        }

        public Raster getRaster(int x, int y, int w, int h) {
            ColorSpace cs = this.getColorModel().getColorSpace();
            PDFFunction[] functions = ShaderType2.this.getFunctions();
            int numComponents = cs.getNumComponents();
            float x0 = (float)this.start.getX();
            float x1 = (float)this.end.getX();
            float y0 = (float)this.start.getY();
            float y1 = (float)this.end.getY();
            float[] inputs = new float[1];
            float[] outputs = new float[numComponents];
            int[] data = new int[w * h * (numComponents + 1)];
            int j = 0;
            while (j < h) {
                int i = 0;
                while (i < w + 8) {
                    float t;
                    float xp = this.getXPrime(i + x, j + y, x0, y0, x1, y1);
                    inputs[0] = t = this.getT(xp);
                    if (functions.length == 1) {
                        functions[0].calculate(inputs, 0, outputs, 0);
                    } else {
                        int c = 0;
                        while (c < functions.length) {
                            functions[c].calculate(inputs, 0, outputs, c);
                            ++c;
                        }
                    }
                    int q = i;
                    while (q < i + 8 && q < w) {
                        int base = (j * w + q) * (numComponents + 1);
                        int c = 0;
                        while (c < numComponents) {
                            data[base + c] = (int)(outputs[c] * 255.0f);
                            ++c;
                        }
                        data[base + numComponents] = 255;
                        ++q;
                    }
                    i += 8;
                }
                ++j;
            }
            WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
            raster.setPixels(0, 0, w, h, data);
            Raster child = raster.createTranslatedChild(x, y);
            return child;
        }

        private float getXPrime(float x, float y, float x0, float y0, float x1, float y1) {
            double tp = (double)((x1 - x0) * (x - x0) + (y1 - y0) * (y - y0)) / (Math.pow(x1 - x0, 2.0) + Math.pow(y1 - y0, 2.0));
            return (float)tp;
        }

        private float getT(float xp) {
            float t0 = ShaderType2.this.getMinT();
            float t1 = ShaderType2.this.getMaxT();
            if (xp < 0.0f) {
                return t0;
            }
            if (xp > 1.0f) {
                return t1;
            }
            return t0 + (t1 - t0) * xp;
        }
    }
}

