/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.function;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.function.FunctionType0;
import com.sun.pdfview.function.PDFFunction;
import java.io.IOException;

public class FunctionType3
extends PDFFunction {
    private PDFFunction[] functions;
    private float[] bounds;
    private float[] encode;

    protected FunctionType3() {
        super(3);
    }

    protected void parse(PDFObject obj) throws IOException {
        if (this.getNumInputs() != 1) {
            throw new PDFParseException("Type 3 function only accepts a single input, so Domain should have just 2 elements");
        }
        PDFObject functionsObj = obj.getDictRef("Functions");
        if (functionsObj == null) {
            throw new PDFParseException("Functions required for function type 3!");
        }
        PDFObject[] functionsAry = functionsObj.getArray();
        this.functions = new PDFFunction[functionsAry.length];
        int i = 0;
        while (i < functionsAry.length) {
            this.functions[i] = PDFFunction.getFunction(functionsAry[i]);
            ++i;
        }
        int k = this.functions.length;
        PDFObject domainObj = obj.getDictRef("Domain");
        if (domainObj == null) {
            throw new PDFParseException("domain required for function type 3!");
        }
        PDFObject boundsObj = obj.getDictRef("Bounds");
        if (boundsObj == null) {
            throw new PDFParseException("Bounds required for function type 3!");
        }
        PDFObject[] boundsAry = boundsObj.getArray();
        if (boundsAry.length != k - 1) {
            throw new PDFParseException("Bounds array length " + boundsAry.length + " should be " + (k - 1) + " with functions array length " + this.functions.length);
        }
        this.bounds = new float[boundsAry.length];
        int i2 = 0;
        while (i2 < boundsAry.length) {
            this.bounds[i2] = boundsAry[i2].getFloatValue();
            ++i2;
        }
        PDFObject encodeObj = obj.getDictRef("Encode");
        if (encodeObj == null) {
            throw new PDFParseException("Encode required for function type 3!");
        }
        PDFObject[] encodeAry = encodeObj.getArray();
        if (encodeAry.length != 2 * k) {
            throw new PDFParseException("There should be " + 2 * k + " values in Encode for the given number of functions.");
        }
        this.encode = new float[encodeAry.length];
        int i3 = 0;
        while (i3 < encodeAry.length) {
            this.encode[i3] = encodeAry[i3].getFloatValue();
            ++i3;
        }
    }

    protected void doFunction(float[] inputs, int inputOffset, float[] outputs, int outputOffset) {
        float input = inputs[inputOffset];
        int subdomain = 0;
        while (subdomain < this.bounds.length && input >= this.bounds[subdomain]) {
            ++subdomain;
        }
        float boundMin = subdomain == 0 ? this.getDomain(0) : this.bounds[subdomain - 1];
        float boundMax = subdomain == this.bounds.length ? this.getDomain(1) : this.bounds[subdomain];
        float encodedInput = FunctionType0.interpolate(input, boundMin, boundMax, this.encode[subdomain * 2], this.encode[subdomain * 2 + 1]);
        float[] subfuncInputArr = new float[]{encodedInput};
        this.functions[subdomain].calculate(subfuncInputArr, 0, outputs, outputOffset);
    }
}

