/*
 * Decompiled with CFR 0.152.
 */
package org.openJpeg;

import java.util.Objects;
import org.openJpeg.OpenJPEGJavaCoder;

public class OpenJPEGJavaEncoder
extends OpenJPEGJavaCoder {
    private boolean isLossyEncoding = false;
    private float quality = 1.0f;

    public OpenJPEGJavaEncoder() {
        this.nativePtr = this.nativeConstruct();
    }

    public OpenJPEGJavaEncoder(boolean bl, float f, int n) {
        this.nativePtr = this.nativeConstruct();
        this.isLossyEncoding = bl;
        this.quality = f;
        this.threads = n;
    }

    public byte[] encode(Object object) {
        this.validateSettings(object);
        this.nativeSetParameters(this.nativePtr, this.isLossyEncoding, this.quality, this.threads, this.width, this.height, this.nofComp, this.usedBitsPerComp, this.isSignedData);
        if (object instanceof byte[]) {
            return this.encodeFromByte((byte[])object);
        }
        if (object instanceof short[]) {
            return this.encodeFromShort((short[])object);
        }
        if (object instanceof int[]) {
            return this.encodeFromInt((int[])object);
        }
        throw new IllegalArgumentException("Uncompressed data array of unsupported type " + object.getClass().getSimpleName());
    }

    private byte[] encodeFromByte(byte[] byArray) {
        return this.nativeEncodeFromByte(this.nativePtr, byArray, byArray.length);
    }

    private byte[] encodeFromShort(short[] sArray) {
        return this.nativeEncodeFromShort(this.nativePtr, sArray, sArray.length);
    }

    private byte[] encodeFromInt(int[] nArray) {
        return this.nativeEncodeFromInt(this.nativePtr, nArray, nArray.length);
    }

    public boolean isLossyEncoding() {
        return this.isLossyEncoding;
    }

    public void setLossyEncoding(boolean bl) {
        this.isLossyEncoding = bl;
    }

    public float getQuality() {
        return this.quality;
    }

    public void setQuality(float f) {
        this.quality = f;
    }

    @Override
    protected void validateSettings(Object ... objectArray) {
        super.validateSettings(new Object[0]);
        if (Objects.isNull(objectArray[0])) {
            throw new IllegalArgumentException("Input must be non-null");
        }
        if (this.width < 0) {
            throw new IllegalStateException("Image width is " + this.width);
        }
        if (this.height < 0) {
            throw new IllegalStateException("Image height is " + this.height);
        }
        if (this.nofComp != 1 && this.nofComp != 3) {
            throw new IllegalStateException("Number of image components is " + this.nofComp);
        }
        if (this.nofComp == 1 && (this.usedBitsPerComp < 0 || this.usedBitsPerComp > 16)) {
            throw new IllegalStateException("Used bits number " + this.usedBitsPerComp + " invalid for 1-comp image");
        }
        if (this.nofComp == 3 && this.usedBitsPerComp != 8) {
            throw new IllegalStateException("Used bits number " + this.usedBitsPerComp + " invalid for 3-comp image");
        }
        if (this.isLossyEncoding && ((double)this.quality < 1.0E-5 || (double)this.quality > 1.00001)) {
            throw new IllegalStateException("Quality of " + this.quality + " not supported for lossy encoding");
        }
    }

    private native void nativeSetParameters(long var1, boolean var3, float var4, int var5, int var6, int var7, int var8, int var9, boolean var10);

    private native byte[] nativeEncodeFromByte(long var1, byte[] var3, int var4);

    private native byte[] nativeEncodeFromShort(long var1, short[] var3, int var4);

    private native byte[] nativeEncodeFromInt(long var1, int[] var3, int var4);
}

