/*
 * Decompiled with CFR 0.152.
 */
package org.openJpeg;

public abstract class OpenJPEGJavaCoder {
    protected int width = 0;
    protected int height = 0;
    protected boolean isSignedData = false;
    protected int allocBitsPerComp = 0;
    protected int usedBitsPerComp = 0;
    protected int nofComp = 0;
    protected int threads = 1;
    protected long nativePtr = 0L;

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public boolean isSignedData() {
        return this.isSignedData;
    }

    public void setSignedData(boolean bl) {
        this.isSignedData = bl;
    }

    public int getNofComponents() {
        return this.nofComp;
    }

    public void setNofComponents(int n) {
        this.nofComp = n;
    }

    public int getAllocatedBitsPerComponent() {
        return this.allocBitsPerComp;
    }

    public void setAllocatedBitsPerComponent(int n) {
        this.allocBitsPerComp = n;
    }

    public int getUsedBitsPerComponent() {
        return this.usedBitsPerComp;
    }

    public void setUsedBitsPerComponent(int n) {
        this.usedBitsPerComp = n;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int n) {
        this.threads = n;
    }

    public int getNeededMemory() {
        return this.width * this.height * this.nofComp;
    }

    protected void reset() {
        this.width = 0;
        this.height = 0;
        this.nofComp = 0;
        this.allocBitsPerComp = 0;
        this.usedBitsPerComp = 0;
        this.isSignedData = false;
    }

    public void destroy() {
        this.nativeDestruct(this.nativePtr);
        this.nativePtr = 0L;
    }

    protected void validateSettings(Object ... objectArray) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Native data instance is null");
        }
        if (this.threads <= 0) {
            throw new IllegalStateException("Illegal number of threads: " + this.threads);
        }
    }

    protected native long nativeConstruct();

    protected native void nativeDestruct(long var1);
}

