/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.itk.simple.SimpleITKJNI;
import org.itk.simple.Transform;

public class VectorOfTransform
extends AbstractList<Transform>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorOfTransform(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorOfTransform vectorOfTransform) {
        return vectorOfTransform == null ? 0L : vectorOfTransform.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_VectorOfTransform(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorOfTransform(Transform[] transformArray) {
        this();
        this.reserve(transformArray.length);
        for (Transform transform : transformArray) {
            this.add(transform);
        }
    }

    public VectorOfTransform(Iterable<Transform> iterable) {
        this();
        for (Transform transform : iterable) {
            this.add(transform);
        }
    }

    @Override
    public Transform get(int n) {
        return this.doGet(n);
    }

    @Override
    public Transform set(int n, Transform transform) {
        return this.doSet(n, transform);
    }

    @Override
    public boolean add(Transform transform) {
        ++this.modCount;
        this.doAdd(transform);
        return true;
    }

    @Override
    public void add(int n, Transform transform) {
        ++this.modCount;
        this.doAdd(n, transform);
    }

    @Override
    public Transform remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public VectorOfTransform() {
        this(SimpleITKJNI.new_VectorOfTransform__SWIG_0(), true);
    }

    public VectorOfTransform(VectorOfTransform vectorOfTransform) {
        this(SimpleITKJNI.new_VectorOfTransform__SWIG_1(VectorOfTransform.getCPtr(vectorOfTransform), vectorOfTransform), true);
    }

    public long capacity() {
        return SimpleITKJNI.VectorOfTransform_capacity(this.swigCPtr, this);
    }

    public void reserve(long l) {
        SimpleITKJNI.VectorOfTransform_reserve(this.swigCPtr, this, l);
    }

    @Override
    public boolean isEmpty() {
        return SimpleITKJNI.VectorOfTransform_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        SimpleITKJNI.VectorOfTransform_clear(this.swigCPtr, this);
    }

    public VectorOfTransform(int n, Transform transform) {
        this(SimpleITKJNI.new_VectorOfTransform__SWIG_2(n, Transform.getCPtr(transform), transform), true);
    }

    private int doSize() {
        return SimpleITKJNI.VectorOfTransform_doSize(this.swigCPtr, this);
    }

    private void doAdd(Transform transform) {
        SimpleITKJNI.VectorOfTransform_doAdd__SWIG_0(this.swigCPtr, this, Transform.getCPtr(transform), transform);
    }

    private void doAdd(int n, Transform transform) {
        SimpleITKJNI.VectorOfTransform_doAdd__SWIG_1(this.swigCPtr, this, n, Transform.getCPtr(transform), transform);
    }

    private Transform doRemove(int n) {
        return new Transform(SimpleITKJNI.VectorOfTransform_doRemove(this.swigCPtr, this, n), true);
    }

    private Transform doGet(int n) {
        return new Transform(SimpleITKJNI.VectorOfTransform_doGet(this.swigCPtr, this, n), false);
    }

    private Transform doSet(int n, Transform transform) {
        return new Transform(SimpleITKJNI.VectorOfTransform_doSet(this.swigCPtr, this, n, Transform.getCPtr(transform), transform), true);
    }

    private void doRemoveRange(int n, int n2) {
        SimpleITKJNI.VectorOfTransform_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

