/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ImageFilter;
import org.itk.simple.SimpleITKJNI;
import org.itk.simple.VectorUInt32;

public class SLICImageFilter
extends ImageFilter {
    private transient long swigCPtr;

    protected SLICImageFilter(long l, boolean bl) {
        super(SimpleITKJNI.SLICImageFilter_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(SLICImageFilter sLICImageFilter) {
        return sLICImageFilter == null ? 0L : sLICImageFilter.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_SLICImageFilter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public SLICImageFilter() {
        this(SimpleITKJNI.new_SLICImageFilter(), true);
    }

    public void setSuperGridSize(VectorUInt32 vectorUInt32) {
        SimpleITKJNI.SLICImageFilter_setSuperGridSize(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public VectorUInt32 getSuperGridSize() {
        return new VectorUInt32(SimpleITKJNI.SLICImageFilter_getSuperGridSize(this.swigCPtr, this), true);
    }

    public void setSpatialProximityWeight(double d) {
        SimpleITKJNI.SLICImageFilter_setSpatialProximityWeight(this.swigCPtr, this, d);
    }

    public double getSpatialProximityWeight() {
        return SimpleITKJNI.SLICImageFilter_getSpatialProximityWeight(this.swigCPtr, this);
    }

    public void setMaximumNumberOfIterations(long l) {
        SimpleITKJNI.SLICImageFilter_setMaximumNumberOfIterations(this.swigCPtr, this, l);
    }

    public long getMaximumNumberOfIterations() {
        return SimpleITKJNI.SLICImageFilter_getMaximumNumberOfIterations(this.swigCPtr, this);
    }

    public void setEnforceConnectivity(boolean bl) {
        SimpleITKJNI.SLICImageFilter_setEnforceConnectivity(this.swigCPtr, this, bl);
    }

    public void enforceConnectivityOn() {
        SimpleITKJNI.SLICImageFilter_enforceConnectivityOn(this.swigCPtr, this);
    }

    public void enforceConnectivityOff() {
        SimpleITKJNI.SLICImageFilter_enforceConnectivityOff(this.swigCPtr, this);
    }

    public boolean getEnforceConnectivity() {
        return SimpleITKJNI.SLICImageFilter_getEnforceConnectivity(this.swigCPtr, this);
    }

    public void setInitializationPerturbation(boolean bl) {
        SimpleITKJNI.SLICImageFilter_setInitializationPerturbation(this.swigCPtr, this, bl);
    }

    public void initializationPerturbationOn() {
        SimpleITKJNI.SLICImageFilter_initializationPerturbationOn(this.swigCPtr, this);
    }

    public void initializationPerturbationOff() {
        SimpleITKJNI.SLICImageFilter_initializationPerturbationOff(this.swigCPtr, this);
    }

    public boolean getInitializationPerturbation() {
        return SimpleITKJNI.SLICImageFilter_getInitializationPerturbation(this.swigCPtr, this);
    }

    public double getAverageResidual() {
        return SimpleITKJNI.SLICImageFilter_getAverageResidual(this.swigCPtr, this);
    }

    @Override
    public String getName() {
        return SimpleITKJNI.SLICImageFilter_getName(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.SLICImageFilter_toString(this.swigCPtr, this);
    }

    public Image execute(Image image) {
        return new Image(SimpleITKJNI.SLICImageFilter_execute(this.swigCPtr, this, Image.getCPtr(image), image), true);
    }
}

