/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ProcessObject;
import org.itk.simple.SimpleITKJNI;

public class HashImageFilter
extends ProcessObject {
    private transient long swigCPtr;

    protected HashImageFilter(long l, boolean bl) {
        super(SimpleITKJNI.HashImageFilter_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(HashImageFilter hashImageFilter) {
        return hashImageFilter == null ? 0L : hashImageFilter.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_HashImageFilter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public HashImageFilter() {
        this(SimpleITKJNI.new_HashImageFilter(), true);
    }

    public void setHashFunction(HashFunction hashFunction) {
        SimpleITKJNI.HashImageFilter_setHashFunction(this.swigCPtr, this, hashFunction.swigValue());
    }

    public HashFunction getHashFunction() {
        return HashFunction.swigToEnum(SimpleITKJNI.HashImageFilter_getHashFunction(this.swigCPtr, this));
    }

    @Override
    public String getName() {
        return SimpleITKJNI.HashImageFilter_getName(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.HashImageFilter_toString(this.swigCPtr, this);
    }

    public String execute(Image image) {
        return SimpleITKJNI.HashImageFilter_execute(this.swigCPtr, this, Image.getCPtr(image), image);
    }

    public static final class HashFunction {
        public static final HashFunction SHA1 = new HashFunction("SHA1");
        public static final HashFunction MD5 = new HashFunction("MD5");
        private static HashFunction[] swigValues = new HashFunction[]{SHA1, MD5};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static HashFunction swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && HashFunction.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (HashFunction.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + HashFunction.class + " with value " + n);
        }

        private HashFunction(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private HashFunction(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private HashFunction(String string, HashFunction hashFunction) {
            this.swigName = string;
            this.swigValue = hashFunction.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

