/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ImageFilter;
import org.itk.simple.PixelIDValueEnum;
import org.itk.simple.SimpleITKJNI;
import org.itk.simple.VectorDouble;
import org.itk.simple.VectorUInt32;

public class GaussianImageSource
extends ImageFilter {
    private transient long swigCPtr;

    protected GaussianImageSource(long l, boolean bl) {
        super(SimpleITKJNI.GaussianImageSource_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(GaussianImageSource gaussianImageSource) {
        return gaussianImageSource == null ? 0L : gaussianImageSource.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_GaussianImageSource(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public GaussianImageSource() {
        this(SimpleITKJNI.new_GaussianImageSource(), true);
    }

    public void setOutputPixelType(PixelIDValueEnum pixelIDValueEnum) {
        SimpleITKJNI.GaussianImageSource_setOutputPixelType(this.swigCPtr, this, pixelIDValueEnum.swigValue());
    }

    public PixelIDValueEnum getOutputPixelType() {
        return PixelIDValueEnum.swigToEnum(SimpleITKJNI.GaussianImageSource_getOutputPixelType(this.swigCPtr, this));
    }

    public void setSize(VectorUInt32 vectorUInt32) {
        SimpleITKJNI.GaussianImageSource_setSize(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public VectorUInt32 getSize() {
        return new VectorUInt32(SimpleITKJNI.GaussianImageSource_getSize(this.swigCPtr, this), true);
    }

    public void setSigma(VectorDouble vectorDouble) {
        SimpleITKJNI.GaussianImageSource_setSigma__SWIG_0(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public void setSigma(double d) {
        SimpleITKJNI.GaussianImageSource_setSigma__SWIG_1(this.swigCPtr, this, d);
    }

    public VectorDouble getSigma() {
        return new VectorDouble(SimpleITKJNI.GaussianImageSource_getSigma(this.swigCPtr, this), true);
    }

    public void setMean(VectorDouble vectorDouble) {
        SimpleITKJNI.GaussianImageSource_setMean__SWIG_0(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public void setMean(double d) {
        SimpleITKJNI.GaussianImageSource_setMean__SWIG_1(this.swigCPtr, this, d);
    }

    public VectorDouble getMean() {
        return new VectorDouble(SimpleITKJNI.GaussianImageSource_getMean(this.swigCPtr, this), true);
    }

    public void setScale(double d) {
        SimpleITKJNI.GaussianImageSource_setScale(this.swigCPtr, this, d);
    }

    public double getScale() {
        return SimpleITKJNI.GaussianImageSource_getScale(this.swigCPtr, this);
    }

    public void setOrigin(VectorDouble vectorDouble) {
        SimpleITKJNI.GaussianImageSource_setOrigin(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getOrigin() {
        return new VectorDouble(SimpleITKJNI.GaussianImageSource_getOrigin(this.swigCPtr, this), true);
    }

    public void setSpacing(VectorDouble vectorDouble) {
        SimpleITKJNI.GaussianImageSource_setSpacing(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getSpacing() {
        return new VectorDouble(SimpleITKJNI.GaussianImageSource_getSpacing(this.swigCPtr, this), true);
    }

    public void setDirection(VectorDouble vectorDouble) {
        SimpleITKJNI.GaussianImageSource_setDirection(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getDirection() {
        return new VectorDouble(SimpleITKJNI.GaussianImageSource_getDirection(this.swigCPtr, this), true);
    }

    public void setNormalized(boolean bl) {
        SimpleITKJNI.GaussianImageSource_setNormalized(this.swigCPtr, this, bl);
    }

    public void normalizedOn() {
        SimpleITKJNI.GaussianImageSource_normalizedOn(this.swigCPtr, this);
    }

    public void normalizedOff() {
        SimpleITKJNI.GaussianImageSource_normalizedOff(this.swigCPtr, this);
    }

    public boolean getNormalized() {
        return SimpleITKJNI.GaussianImageSource_getNormalized(this.swigCPtr, this);
    }

    @Override
    public String getName() {
        return SimpleITKJNI.GaussianImageSource_getName(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.GaussianImageSource_toString(this.swigCPtr, this);
    }

    public Image execute() {
        return new Image(SimpleITKJNI.GaussianImageSource_execute(this.swigCPtr, this), true);
    }
}

