/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ImageFilter;
import org.itk.simple.SimpleITKJNI;
import org.itk.simple.VectorUInt32;
import org.itk.simple.VectorUIntList;

public class ConnectedThresholdImageFilter
extends ImageFilter {
    private transient long swigCPtr;

    protected ConnectedThresholdImageFilter(long l, boolean bl) {
        super(SimpleITKJNI.ConnectedThresholdImageFilter_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(ConnectedThresholdImageFilter connectedThresholdImageFilter) {
        return connectedThresholdImageFilter == null ? 0L : connectedThresholdImageFilter.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_ConnectedThresholdImageFilter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public ConnectedThresholdImageFilter() {
        this(SimpleITKJNI.new_ConnectedThresholdImageFilter(), true);
    }

    public void setSeedList(VectorUIntList vectorUIntList) {
        SimpleITKJNI.ConnectedThresholdImageFilter_setSeedList(this.swigCPtr, this, VectorUIntList.getCPtr(vectorUIntList), vectorUIntList);
    }

    public VectorUIntList getSeedList() {
        return new VectorUIntList(SimpleITKJNI.ConnectedThresholdImageFilter_getSeedList(this.swigCPtr, this), true);
    }

    public void addSeed(VectorUInt32 vectorUInt32) {
        SimpleITKJNI.ConnectedThresholdImageFilter_addSeed(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public void clearSeeds() {
        SimpleITKJNI.ConnectedThresholdImageFilter_clearSeeds(this.swigCPtr, this);
    }

    public void setLower(double d) {
        SimpleITKJNI.ConnectedThresholdImageFilter_setLower(this.swigCPtr, this, d);
    }

    public double getLower() {
        return SimpleITKJNI.ConnectedThresholdImageFilter_getLower(this.swigCPtr, this);
    }

    public void setUpper(double d) {
        SimpleITKJNI.ConnectedThresholdImageFilter_setUpper(this.swigCPtr, this, d);
    }

    public double getUpper() {
        return SimpleITKJNI.ConnectedThresholdImageFilter_getUpper(this.swigCPtr, this);
    }

    public void setReplaceValue(short s) {
        SimpleITKJNI.ConnectedThresholdImageFilter_setReplaceValue(this.swigCPtr, this, s);
    }

    public short getReplaceValue() {
        return SimpleITKJNI.ConnectedThresholdImageFilter_getReplaceValue(this.swigCPtr, this);
    }

    public void setConnectivity(ConnectivityType connectivityType) {
        SimpleITKJNI.ConnectedThresholdImageFilter_setConnectivity(this.swigCPtr, this, connectivityType.swigValue());
    }

    public ConnectivityType getConnectivity() {
        return ConnectivityType.swigToEnum(SimpleITKJNI.ConnectedThresholdImageFilter_getConnectivity(this.swigCPtr, this));
    }

    @Override
    public String getName() {
        return SimpleITKJNI.ConnectedThresholdImageFilter_getName(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.ConnectedThresholdImageFilter_toString(this.swigCPtr, this);
    }

    public Image execute(Image image) {
        return new Image(SimpleITKJNI.ConnectedThresholdImageFilter_execute(this.swigCPtr, this, Image.getCPtr(image), image), true);
    }

    public static final class ConnectivityType {
        public static final ConnectivityType FaceConnectivity = new ConnectivityType("FaceConnectivity");
        public static final ConnectivityType FullConnectivity = new ConnectivityType("FullConnectivity");
        private static ConnectivityType[] swigValues = new ConnectivityType[]{FaceConnectivity, FullConnectivity};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static ConnectivityType swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && ConnectivityType.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (ConnectivityType.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + ConnectivityType.class + " with value " + n);
        }

        private ConnectivityType(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private ConnectivityType(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private ConnectivityType(String string, ConnectivityType connectivityType) {
            this.swigName = string;
            this.swigValue = connectivityType.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

